# Anlisis de clasificacin. Ejemplo de Alcobendas 

# Matriz de datos "Alcobendas1.rda" que incluye las variables originales y las factoriales 
# resultado de un ACP: PC1 y PC2 (Sin rotar) y RC1 y RC2 (rotadas)
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/Alcobendas1.rda"))

######## Anlisis de clasificacin jerrquica: Procedimiento 1 
# Anlisis de clasificacin con "hclust"

# Matriz de distancias
dist=dist(Alcobendas1[,c("PC1","PC2")],method="euclidean",diag=T) 
options(max.print=10000)
round(dist,digits=1)
rownames(Alcobendas1)=Alcobendas1$seccion
DAlcobendas=round(as.matrix(dist(Alcobendas1[-1])),2)
View(DAlcobendas)

# Clasificacin jerrquica ascendente con ward
ward=hclust(d=dist,method="ward.D2")
# Dendrograma
plot(ward)
rect.hclust(ward,k=3,border="red")
# Proceso de agregacin
ward$merge
# Coeficiente de distancia a la que se forman los grupos
d=round(ward$height,3)
d
# Incremento o diferencias primeras (resta cada valor del anterior) 
d1=c(0,d[-length(d)])
round(d1,3)
round(d-d1,3)

# Corte del dendrograma en k grupos
G2=cutree(ward,k=2)
G3=cutree(ward,k=3)
G4=cutree(ward,k=4)
G5=cutree(ward,k=5)
Grupos2=as.factor(G2)
Grupos3=as.factor(G3)
Grupos4=as.factor(G4)
Grupos5=as.factor(G5)

# Matriz de datos con las clasificaciones
Alcobendas2=data.frame(Alcobendas1,Grupos2,Grupos3,Grupos4,Grupos5)
save(Alcobendas2,file="C:/Datos/Alcobendas2.rda") # Es preciso especificar la carpeta

# Tabla de frecuencias y cruces
# install.packages(Deducer)
library(Deducer)
frequencies(Alcobendas2[c("Grupos2","Grupos3","Grupos4","Grupos5")],r.digits=1)
table(Grupos4,Grupos5)
table(Grupos3,Grupos4)
table(Grupos2,Grupos3)
round(t(aggregate(Alcobendas2[,2:18],by=list(G5),FUN=mean)),1)
round(t(aggregate(Alcobendas2[,2:18],by=list(G4),FUN=mean)),1)
round(t(aggregate(Alcobendas2[,2:18],by=list(G3),FUN=mean)),1)
round(t(aggregate(Alcobendas2[,2:18],by=list(G2),FUN=mean)),1)

# Unidades segn el grupo en el grfico factorial
ggplot(data=Alcobendas2) + geom_point(aes(x=PC1,y=PC2,colour=Grupos5)) +
  geom_vline(xintercept=0.0) + geom_hline(yintercept=0.0) +
  geom_text(aes(x=PC1,y=PC2,label=seccion),vjust=1.0,hjust=1.0,parse=FALSE)
ggplot(data=Alcobendas2) + geom_point(aes(x=PC1,y=PC2,colour=Grupos3)) +
  geom_vline(xintercept=0.0) + geom_hline(yintercept=0.0) +
  geom_text(aes(x=PC1,y=PC2,label=seccion),vjust=1.0,hjust=1.0,parse=FALSE)


######## Anlisis de clasificacin: Procedimiento 2
# Anlisis de clasificacin con FactoMiner
# install.packages("FactoMineR")
library(FactoMineR)

# Abrir la matriz de datos "Alcobendas.rda"
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/Alcobendas.rda"))
attach(Alcobendas)
DF=data.frame(sinest,super,inmigr,tparom,tactm,paroju,peven,pdtore,poper,ptecn,
              pevenm,ptecnm,padmim,pdomem,ppobjo)
ACP=PCA(DF,ncp=2,graph=F)
summary(ACP)

# ACL jerrquico con Ward
hcpc=HCPC(ACP,min=2,method="ward.D2",nb.clus=-1)    # Eleccin automtica de la particin
hcpc=HCPC(ACP,min=2,method="ward.D2",nb.clus=0)     # Para elegir la particin
# Eleccin del nmero ptimo de grupos o tipos
hcpc$call$t$nb.clust
round(hcpc$call$t$within,3)      # Inercia intraclases
round(hcpc$call$t$quot,3)        # Ratio de inercia intraclases
# Datos de la matriz: Variables originales y tipologa
hcpc$data.clust
# Descripcin de las clases de la clasificacin (tipos de la tipologa)
hcpc$desc.var   # Por los factores
hcpc$desc.axes  # Por los ejes factoriales

Alcobendas3=data.frame(ACP$ind$coord,hcpc$data.clust)
ggplot(data=Alcobendas3) + geom_point(aes(x=Dim.1,y=Dim.2,colour=clust)) +
  geom_vline(xintercept=0.0) + geom_hline(yintercept=0.0)
ggplot(data=Alcobendas3) + geom_point(aes(x=Dim.1,y=Dim.2,colour=clust)) + 
  geom_vline(xintercept=0.0) + geom_hline(yintercept=0.0) + 
  geom_text(aes(x=Dim.1,y=Dim.2,label=seccion),vjust=1.0,parse=FALSE)

# Para guardar la matriz de datos con la clasificacin
save(Alcobendas3,file="C:/Datos/Alcobendas3.rda")
write.infile(Alcobendas3, file="C:/Datos/Alcobendas3.xls", sep="\t")



