# install.packages("FactoMineR")
library(FactoMineR)

load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/Conciliacion.rda"))

attach(Conciliacion)
DF=data.frame(Sexo,Edad,Estudios,Seccion,Antiguedad,Categora,Contrato,Horario,Cocina,
              Limpia,Cuida,Bricolaje,Compra,Dif_hogar,Dif_cuidado,Dif_asocia,Dif_ocioI,
              Dif_ocioF,Dif_ocioA,Coincide,Convive,Dependencia,Ocupado)

library(Deducer)
frequencies(Conciliacion[c("Sexo","Edad","Estudios","Seccion","Antiguedad","Categora",
                           "Contrato","Horario","Cocina","Limpia","Cuida","Bricolaje",
                           "Compra","Dif_hogar","Dif_cuidado","Dif_asocia","Dif_ocioI",
                           "Dif_ocioF","Dif_ocioA","Coincide","Convive","Dependencia",
                           "Ocupado")],r.digits=1)

ACM=MCA(DF,ncp=2,na.method="Average")                # Datos sin ponderar
ACM=MCA(DF,ncp=2,na.method="Average",row.w=Pondera)  # Ponderando los datos
summary(ACM)
ACM$eig #Valores propios (eigen values)
ACM$var
round(ACM$var$coord,2)
round(ACM$var$contrib,2)
round(ACM$var$cos2,2)
round(ACM$var$v.test,2)
round(ACM$var$eta2,2)

# Anlisis de clasificacin jerrquica
hcpc=HCPC(ACM,min=3,method="ward",nb.clus=-1)    # Eleccin automtica de la particin
hcpc=HCPC(ACM,min=3,method="ward",nb.clus=0)     # Para elegir la particin
# Eleccin del nmero ptimo de grupos o tipos
hcpc$call$t$nb.clust
round(hcpc$call$t$within,3)      # Inercia intraclases
round(hcpc$call$t$quot,3)        # Ratio de inercia intraclases
round(hcpc$call$t$inert.gain,3)  # Ganancia de inercia entre clases
# Descripcin de las clases de la clasificacin (tipos de la tipologa)
hcpc$desc.var$test.chi2   #Variables
hcpc$desc.var$category    #Categoras
hcpc$desc.axes            #Factores
hcpc$desc.ind             #individuos

CLU=data.frame(ACM$ind$coord,hcpc$data.clust)
ggplot(data=CLU) + geom_point(aes(x=Dim.1,y=Dim.2,colour=clust)) +
  geom_vline(xintercept=0.0) + geom_hline(yintercept=0.0)

# Visualizadores alternativos de resultados
# install.packages("Factoshiny")
library(Factoshiny)
MCAshiny(DF)   # Datos sin ponderar
