* Encoding: windows-1252.
TITLE Anlisis de Clasificacin con ACP previo.

* Construccin muestra estratificada Encuesta de Condiciones de Vida 1990.
* Explotacin datos Padrn 1986. Regin Metropolitana de Barcelona. 

GET  FILE='D:\DATOS\RMB1986.sav'.

FREQUENCIES VARIABLES=P1 TO P23
  /FORMAT=NOTABLE
  /HISTOGRAM NORMAL.

EXAMINE VARIABLES=P1 TO P23
  /PLOT BOXPLOT NPPLOT
  /COMPARE GROUPS
  /STATISTICS DESCRIPTIVES
  /CINTERVAL 95
  /MISSING LISTWISE
  /NOTOTAL.

FACTOR VARIABLES=P1 TO P23
 /ANALYSIS=P1 P2 P4 P6 TO P9 P11 P12 P14 P15 TO P20 P23
 /FORMAT=SORT
 /PRINT=ALL
 /CRITERIA=FACTORS(4)
 /EXTRACTION=PC
 /ROTATION=NOROTATE
 /PLOT=EIGEN ROTATION (1,2) (3,4)
 /SAVE=REG (ALL Factor0).

FACTOR VARIABLES=P1 TO P23
 /ANALYSIS=P1 P2 P4 P6 TO P9 P11 P12 P14 P15 TO P20 P23
 /FORMAT=SORT
 /PRINT=ALL
 /CRITERIA=FACTORS(4)
 /EXTRACTION=PC
 /ROTATION=VARIMAX
 /PLOT=EIGEN ROTATION (1,2) (3,4)
 /SAVE=REG (ALL Factor).

DESCRIPTIVES P1 TO P23 Factor1 Factor2 Factor3 Factor4.

* Generador de grficos.
GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=Factor1 Factor2 MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: Factor1=col(source(s), name("Factor1"))
  DATA: Factor2=col(source(s), name("Factor2"))
  GUIDE: axis(dim(1), label("REGR factor score   1 for analysis"))
  GUIDE: axis(dim(2), label("REGR factor score   2 for analysis"))
  ELEMENT: point(position(Factor1*Factor2))
END GPL.

* Generador de grficos.
GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=Factor1 Factor2 Factor3 MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: Factor1=col(source(s), name("Factor1"))
  DATA: Factor2=col(source(s), name("Factor2"))
  DATA: Factor3=col(source(s), name("Factor3"))
  COORD: rect(dim(1.2.3))
  GUIDE: axis(dim(1), label("REGR factor score   3 for analysis"))
  GUIDE: axis(dim(2), label("REGR factor score   1 for analysis"))
  GUIDE: axis(dim(3), label("REGR factor score   2 for analysis"))
  ELEMENT: point(position(Factor3*Factor1*Factor2))
END GPL.

DESCRIPTIVES VARIABLES=P23
  /SAVE
  /STATISTICS=MEAN STDDEV MIN MAX.

CLUSTER   Factor1 Factor2 Factor3 Factor4 ZP23
  /METHOD WARD
  /MEASURE=SEUCLID
  /PRINT SCHEDULE
  /PLOT NONE
  /SAVE CLUSTER(2,15).

FREQUENCIES CLU8_1.

MEANS TABLES=Factor1 Factor2 Factor3 Factor4 ZP23 BY CLU8_1
  /CELLS=MEAN.

QUICK CLUSTER Factor1 Factor2 Factor3 Factor4 ZP23
 /INITITAL=(-.1767260	.3213484	1.5428046	.4730599	1.2451725	
.3082115	-.0131104	6.1947601	.0658566	7.2020551	
1.6977952	.5227535	-.1969605	-.9164677	-.2676976	
.2758603	-.4441035	-.2270427	-.3503201	-.2574378	
-.8703769	.9765133	-.1567048	-.6998694	-.0974175	
-1.0210065	.3276408	-.2137176	.4894210	-.1770689	
-.5226420	-2.2938018	-.0773603	-.0776977	-.2678975	
.5826781	.0587534	-.3439285	1.4673010	-.2066012)
  /MISSING=LISTWISE
  /CRITERIA=CLUSTER(8) MXITER(10) CONVERGE(0)
  /METHOD=KMEANS(NOUPDATE)
  /SAVE CLUSTER(QCLW) DISTANCE(DQCLW)
  /PRINT INITIAL ANOVA
  /OUTFILE='D:\Datos\Centros finales.sav'.

MEANS TABLES=Factor1 Factor2 Factor3 Factor4 ZP23 P1 TO P23
   BY CLU8_1
  /CELLS=MEAN.



