# Anlisis de clasificacin. 
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/IDH2014.rda"))

attach(IDH2014)
DF=data.frame(Lifeexpectancy,Schooling,GNIpercapita2011)
library(psych)
ACP=principal(DF,nfactors=2,rotate="none",covar= FALSE,scores=TRUE)
ACP

IDH=data.frame(HDIrank,Country,HDI,DF,ACP$scores)
ggplot() + geom_point(aes(x=PC1,y=PC2),data=IDH) + geom_text(aes(x=PC1,y=PC2,label = Country),data=IDH,parse = FALSE)

IDH=data.frame(na.omit(IDH)) # Se suprimen los casos con valores perdidos

# Matriz de distancias
dist=dist(IDH[,c("PC1","PC2")],method="euclidean",diag=T) 
rownames(IDH)=IDH$Country
DIDH=round(as.matrix(dist(IDH[-1])),2)
View(DIDH)
# Clasificacin jerrquica ascendente con ward
ward=hclust(d=dist,method="ward.D2")
# Dendrograma
plot(ward)
rect.hclust(ward,k=3,border="red")
# Proceso de agregacin
ward$merge
# Coeficiente de distancia a la que se forman los grupos
d=round(ward$height,3)
d
# Incremento o diferencias primeras (resta cada valor del anterior) 
d1=c(0,d[-length(d)])
round(d1,3)
round(d-d1,3)


# Corte del dendrograma en k grupos
G2=cutree(ward,k=2)
G3=cutree(ward,k=3)
G4=cutree(ward,k=4)
G5=cutree(ward,k=5)
Grupos2=as.factor(G2)
Grupos3=as.factor(G3)
Grupos4=as.factor(G4)
Grupos5=as.factor(G5)

# Matriz de datos con las clasificaciones
IDH=data.frame(IDH,Grupos2,Grupos3,Grupos4,Grupos5)
save(IDH,file="C:/Datos/IDH.rda")

# Tabla de frecuencias y cruces
# install.packages(Deducer)
library(Deducer)
frequencies(IDH[c("Grupos2","Grupos3","Grupos4","Grupos5")],r.digits=1)
table(Grupos4,Grupos5)
table(Grupos3,Grupos4)
table(Grupos2,Grupos3)
round(t(aggregate(IDH2[,2:6],by=list(G5),FUN=mean)),1)
round(t(aggregate(IDH2[,2:6],by=list(G4),FUN=mean)),1)
round(t(aggregate(IDH2[,2:6],by=list(G3),FUN=mean)),1)
round(t(aggregate(IDH2[,2:6],by=list(G2),FUN=mean)),1)

# Unidades segn el grupo en el grfico factorial
ggplot(data=IDH) + geom_point(aes(x=PC1,y=PC2,colour=Grupos5)) + 
                    geom_vline(xintercept=0.0) + geom_hline(yintercept=0.0)
ggplot(data=IDH) + geom_point(aes(x=PC1,y=PC2,colour=Grupos5)) + 
                   geom_vline(xintercept=0.0) + geom_hline(yintercept=0.0) +
                   geom_text(aes(x=PC1,y=PC2,label=Country),vjust=1.0,parse=FALSE)
ggplot(data=IDH) + geom_point(aes(x=PC1,y=PC2,colour=Grupos2)) +
                    geom_vline(xintercept=0.0) + geom_hline(yintercept=0.0)
ggplot(data=IDH) + geom_point(aes(x=PC1,y=PC2,colour=Grupos2)) + 
                   geom_vline(xintercept=0.0) + geom_hline(yintercept=0.0) + 
                   geom_text(aes(x=PC1,y=PC2,label=Country),vjust=1.0,parse=FALSE)
ggplot(data=IDH) + geom_point(aes(x=PC1,y=PC2,colour=Grupos3)) +
                   geom_vline(xintercept=0.0) + geom_hline(yintercept=0.0)
ggplot(data=IDH) + geom_point(aes(x=PC1,y=PC2,colour=Grupos3)) + 
                   geom_vline(xintercept=0.0) + geom_hline(yintercept=0.0) + 
                   geom_text(aes(x=PC1,y=PC2,label=Country),vjust=1.0,parse=FALSE)

######## Anlisis de clasificacin: Procedimiento 2
# Anlisis de clasificacin con FactoMiner
# install.packages("FactoMineR")
library(FactoMineR)
# ACP
DF=na.omit(DF)
ACP=PCA(DF,ncp=2,graph=F)
summary(ACP)
# ACL jerrquico con Ward
hcpc=HCPC(ACP,min=2,method="ward",nb.clus=-1)    # Eleccin automtica de la particin
hcpc=HCPC(ACP,min=2,method="ward",nb.clus=0)     # Para elegir la particin
# Eleccin del nmero ptimo de grupos o tipos de la particin
hcpc$call$t$nb.clust
round(hcpc$call$t$within,3)      # Inercia intraclases
round(hcpc$call$t$quot,3)        # Ratio de inercia intraclases
round(hcpc$call$t$inert.gain,3)  # Ganancia de inercia entre clases
# Datos de la matriz: Variables originales y tipologa
hcpc$data.clust
# Descripcin de las clases de la clasificacin (tipos de la tipologa)
hcpc$desc.var   # Por las variables
hcpc$desc.axes  # Por los factores

IDH2=data.frame(IDH$Country,ACP$ind$coord,hcpc$data.clust)
ggplot(data=IDH2) + geom_point(aes(x=Dim.1,y=Dim.2,colour=clust)) +
  geom_vline(xintercept=0.0) + geom_hline(yintercept=0.0)
ggplot(data=IDH2) + geom_point(aes(x=Dim.1,y=Dim.2,colour=clust)) + 
  geom_vline(xintercept=0.0) + geom_hline(yintercept=0.0) + 
  geom_text(aes(x=Dim.1,y=Dim.2,label=Country),vjust=1.0,parse=FALSE)

# Para guardar la matriz de datos con la clasificacin
save(IDH2,file="C:/Datos/IDH2.rda")
write.infile(IDH2, file="C:/Datos/IDH2.xls", sep="\t")
