
# Anlisis de clasificacin con el paquete FactoMineR
# install.packages("FactoMineR")
library(FactoMineR)

# Matriz de datos ejemplo sobre segmentacin del mercado de trabajo: Segmenta.rda
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/EPA4T2014-Segmentacion.rda"))
attach(Segmenta)
DF=data.frame(CONTRATO,JORNADA,DURACION,ANTIGUEDAD,OCUPACION,ACTIVIDAD,EMPRESA,
              EDUCACION,EDAD,SEXO,NACIONALIDAD)
# Submuestra de 10.000 casos
DF2=DF[sample(1:nrow(DF),10000,replace=FALSE),]

# Anlisis de correspondencias mltiples
ACM=MCA(DF2,ncp=2,quali.sup=9:11,na.method="Average") # 9 vars. activas y 3 ilustrativas
summary(ACM)

# Anlisis de clasificacin jerrquica
hcpc=HCPC(ACM,min=2,method="ward.D2",nb.clus=-1)    # Eleccin automtica de la particin
hcpc=HCPC(ACM,min=2,method="ward.D2",nb.clus=0)     # Para elegir la particin
# Eleccin del nmero ptimo de grupos o tipos de la particin
hcpc$call$t$nb.clust
# Descripcin de las clases de la clasificacin (tipos de la tipologa)
hcpc$desc.var$test.chi2   # Variables
hcpc$desc.var$category    # Categoras
hcpc$desc.axes            # Factores
hcpc$desc.ind             # individuos

 
