
# Anlisis de correspondencias mltiples con el paquete FactoMineR
# install.packages("FactoMineR")
library(FactoMineR)

# Matriz de datos ejemplo Actitud.rda
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/Actitud.rda"))
summary(Actitud)
attach(Actitud)
DF=data.frame(ACT,EST,SEX)

# Anlisis de correspondencias mltiples
ACM=MCA(DF,ncp=2,na.method="Average")
ACM
ACM$eig # Valores propios (eigen values)
ACM$var # Tabla de resultados para las categoras de las variables
round(ACM$var$coord,2) # Coordenadas
round(ACM$var$contrib,2) # Contribuciones absolutas
round(ACM$var$cos2,2) # Contribuciones relativas
round(ACM$var$v.test,2) # Valores test de significacin de las categoras de las variables
round(ACM$var$eta2,2) # Medidas discriminantes

# Paquetes de "factoextra" para obtener, en particular, grficos al estilo ggplot2
# install.packages("devtools")
library("devtools")
# install_github("kassambara/factoextra")
library("factoextra")
# install.packages("bindr")
library("bindr")

# Grfico de varianza explicada
get_eigenvalue(ACM) # Tabla de varianza explicada
VE=fviz_screeplot(ACM,addlabels=TRUE)
VE + labs(title="Varianza explicada - ACM", x="Dimensiones", y="% de varianza")
# Grfico de variables
fviz_mca_var(ACM,axes=c(1,2),labelsize=2,repel=TRUE, title="Grfico factorial ACM: categoras")
fviz_mca_var(ACM,axes=c(1,2),geom=c("arrow","text"))
# Grfico de individuos
fviz_mca_ind(ACM)
# Grfico de variables e individuos
fviz_mca_biplot(ACM)
# Tabla de resultados
facto_summarize(ACM, "var", axes = 1:2)
# Grficos de contribuciones
fviz_contrib(ACM, choice="var", axes=1) #Contribuciones absolutas factor 1
fviz_contrib(ACM, choice="var", axes=2) #Contribuciones absolutas factor 2
fviz_cos2(ACM,choice="var", axes=1) #Contribuciones relativas factor 1
fviz_cos2(ACM,choice="var", axes=2) #Contribuciones relativas factor 2

# Visualizador alternativo de resultados en una pgina web
install.packages("Factoshiny")
library(Factoshiny)
MCAshiny(DF)

