
# Anlisis de correspondencias mltiples con el paquete FactoMineR
# install.packages("FactoMineR")
library(FactoMineR)

# Matriz de datos ejemplo sobre segmentacin del mercado de trabajo
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/EPA4T2014-Segmentacion.rda"))
attach(Segmenta)
DF=data.frame(CONTRATO,JORNADA,DURACION,ANTIGUEDAD,OCUPACION,ACTIVIDAD,EMPRESA,
              EDUCACION,EDAD,SEXO,NACIONALIDAD)

# Anlisis de correspondencias mltiples
# Se consideran como variables suplementarias de la 9 a 11: EDAD,SEXO,NACIONALIDAD
# Con na.method="Average" se imputan los valores perdidos con la media
ACM=MCA(DF,ncp=2,quali.sup=9:11,na.method="Average")
ACM
ACM$eig #Valores propios (eigen values)
ACM$var # Tabla de resultados para las categoras de las variables
round(ACM$var$coord,2) # Coordenadas
round(ACM$var$contrib,2) # Contribuciones absolutas
round(ACM$var$cos2,2) # Contribuciones relativas
round(ACM$var$v.test,2) # Valores test de significacin de las categoras de las variables
round(ACM$var$eta2,2) # Medidas discriminantes

# Instalacin de "factoextra" para obtener grficos al estilo ggplot2
# install.packages("devtools")
library("devtools")
# install_github("kassambara/factoextra")
library("factoextra")
# install.packages("bindr")
library("bindr")

# Grfico de varianza explicada
get_eigenvalue(ACM) # Tabla de varianza explicada
VE=fviz_screeplot(ACM,ncp=32,addlabels=TRUE)
VE + labs(title="Varianza explicada - ACM", x="Dimensiones", y="% de varianza")
# Grfico de variables
fviz_mca_var(ACM,axes=c(1,2),labelsize=2,repel=TRUE, title="Grfico factorial ACM: categoras")
fviz_mca_var(ACM,axes=c(1,2),geom=c("arrow","text"))
# Grfico de individuos
fviz_mca_ind(ACM)
# Grfico de variables e individuos
fviz_mca_biplot(ACM)
# Tabla de resultados
facto_summarize(ACM, "var", axes = 1:2)
# Grficos de contribuciones
fviz_contrib(ACM, choice="var", axes=1) #Contribuciones absolutas factor 1
fviz_contrib(ACM, choice="var", axes=2) #Contribuciones absolutas factor 2
fviz_cos2(ACM,choice="var", axes=1) #Contribuciones relativas factor 1
fviz_cos2(ACM,choice="var", axes=2) #Contribuciones relativas factor 2

# Visualizadores alternativos de resultados
# install.packages("Factoshiny")
library(Factoshiny)
MCAshiny(DF)

# Para guardar las variables originales y los factores 
SegmentaF=data.frame(DF,ACM$ind$coord)
save(SegmentaF,file="C:/Datos/SegmentaF.rda")

# Es preciso escribir la direccin de la carpeta

