# Anlisis de Componentes principales. Ejemplo de Alcobendas 

# install.packages("psych")
library(psych)
# install.packages("arm")
library(arm)
# install.packages("Hmisc")
library(Hmisc)

# Matriz de datos "Alcobendas.rda" 
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/Alcobendas.rda"))
attach(Alcobendas)
DF=data.frame(sinest,super,inmigr,tparom,tactm,paroju,peven,pdtore,poper,ptecn,
              pevenm,ptecnm,padmim,pdomem,ppobjo)

######## 1. Anlisis de la matriz de correlaciones
R=cor(DF,use="pairwise.complete.obs")
round(R,digits=1)
rcorr(as.matrix(DF), type="pearson")
det(R)
cor.plot(R)
corrplot(R)
KMO(R)
cortest.bartlett(R,n=32)

######## 2. ACP sin rotacin
ACP=principal(DF, nfactors=2, rotate="none", covar=FALSE, scores=TRUE)
print(ACP, sort=T)
biplot(ACP,choose=c(1,2))
factor.plot(ACP,choose=c(1,2),labels=colnames(seccion))
Alcobendas1=data.frame(Alcobendas,ACP$scores)

######## 3. ACP con rotacin
ACP=principal(DF, nfactors=2, rotate="varimax", covar=FALSE, scores=TRUE)
print(ACP, sort=T)
biplot(ACP,choose=c(1,2))
factor.plot(ACP,choose=c(1,2),labels=colnames(seccion))

# Matriz de Alcobendas con los factores, sin y con rotacin
Alcobendas1=data.frame(Alcobendas1,ACP$scores)
save(Alcobendas1,file='C:/Datos/Alcobendas1.rda')
