# Anlisis de correspondencias simples con el paquete FactoMineR
install.packages("FactoMineR")
library(FactoMineR)

# Introduccin de los datos y anlisis de la tabla entre Ingresos y Ocupacin
tabla=as.table(matrix(c(5,13,25,
                        11,31,61,
                        25,61,66,
                        5,22,9,
                        71,111,74,
                        127,118,48,
                        113,154,71,
                        50,118,57,
                        67,59,18),nrow=3,ncol=9))
colnames(tabla)=c("Director-Gerente","Tcnico-Profesional","Tcnico de apoyo",
                  "Administrativo","Trabajador de servicios",
                  "Cualificado primario","Cualificado industria","Operador",
                  "Ocupacin elemental")
rownames(tabla)=c("Bajos","Medios","Altos")
tabla

# Prueba de chi-cuadrado
chi2=chisq.test(tabla)
chi2

# Anlisis de correspondencias simples
CA=CA(tabla)
CA
CA$eig #Valores propios (eigen values)
CA$call$marge.col # Frecuencia relativa de cada categora en columna
CA$call$marge.row # Frecuencia relativa de cada categora en fila
CA$col$inertia / CA$call$marge.col # Distancia al origen de cada categora en columna
CA$row$inertia / CA$call$marge.row # Distancia al origen de cada categora en fila
CA$col$coord #Coordenadas de las categoras en columna
CA$row$coord #Coordenadas de las categoras en fila
CA$col$contrib #Contribuciones absolutas de las categoras en columna
CA$row$contrib #Contribuciones absolutas de las categoras en fila
CA$col$cos2 #Contribuciones relativas de las categoras en columna
CA$row$cos2 #Contribuciones relativas de las categoras en fila
# Presentacin conjunta
round(cbind(CA$row$coord,CA$row$contrib,CA$row$cos2),2)
round(cbind(CA$col$coord,CA$col$contrib,CA$col$cos2),2)

