* Encoding: UTF-8.

* Anlisis de correspondencias simples.

* A partir de la matriz de datos CIS3041+2.sav o CIS3041+2.sav.

FREQUENCIES VARIABLES=P45 OCUPAFAM.

RECODE P45 (1 THRU 4=1)(5 THRU 6=2)(7 THRU 11=3)(99=4) INTO IngresosH.
VARIABLE LABELS IngresosH 'Ingresos del hogar'.
VALUE LABELS IngresosH 1 'Bajos' 2 'Medios' 3 'Altos' 4 'Sin datos'.
MISSING VALUES IngresosH (4).
FORMATS IngresosH (F1.0).
VARIABLE LEVEL IngresosH (ORDINAL).
VALUE LABELS OCUPAFAM 1 'Director-Gerente'
2 'Profesional'
3 'Tcnico apoyo'
4 'Administrativo'
5 'Trabajador Servicios'
6 'Cualificado Primario'
7 'Cualificado Industria'
8 'Operador-Montador'
9 'Ocupacin elemental'
0 'Sin datos'.
FREQUENCIES OCUPAFAM IngresosH.
CROSSTABS
  /TABLES=IngresosH BY OCUPAFAM
  /FORMAT=AVALUE TABLES
  /STATISTICS=CHISQ PHI 
  /CELLS=COUNT ROW COL
  /COUNT ROUND CELL.

CORRESPONDENCE TABLE=IngresosH(1 3) BY OCUPAFAM(1 9)
  /DIMENSIONS=2
  /MEASURE=CHISQ
  /STANDARDIZE=RCMEAN
  /NORMALIZATION=SYMMETRICAL
  /PRINT=TABLE RPOINTS CPOINTS PERMUTATION(1) RPROFILES CPROFILES RCONF CCONF
  /PLOT=NDIM(1,MAX) BIPLOT(20) TRROWS(20) TRCOLUMNS(20).







