# Data frame Abandono.rda
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/Abandono.rda"))

# Conversin de casos (data frame) a tabla
# Seleccionando las variables
TC=table(abandono$ABA,abandono$ACT,abandono$HOR,dnn=c("ABA","ACT","HOR"))
TC

# Anlisis log-lineal
# Modelo saturado
MS=glm(Freq ~ ABA*HOR*ACT, data=TC, family=poisson(link="log"))
summary(MS)
names(MS)
step(MS, direction="backward", test="Chisq")

# Modelo saturado: cambio de categora de referencia
MS=glm(Freq ~ relevel(ABA,2)*relevel(HOR,3)*relevel(ACT,2), data=TC, family=poisson(link="log"))
summary(MS)
# Funcin step: seleccin de modelo
step(MS, direction="backward", test="Chisq")

