TITLE Anlisis Log-lineal.

* Anlisis de la tabla de contingencia multidimensional a partir de los datos del artculo:
Latiesa, M. (1991). Introduccin a los modelos logartmicos lineales. Papers. Revista de Sociologia, 37, 97-112.

SET TNUMBERS=BOTH TVARS=BOTH ONUMBERS=BOTH OVARS=BOTH. 

* Generacin e identificacin de los datos de la tabla de contingencia.
DATA LIST FREE/ ABA ACT HOR FRE.
BEGIN DATA
1 1 1 100
1 1 2 70
1 1 3 75
1 2 1 17 
1 2 2 50
1 2 3 55
2 1 1 10
2 1 2 25
2 1 3 10
2 2 1 7
2 2 2 20
2 2 3 35
END DATA.
VARIABLE LABELS ABA 'Abandono de los estudios universitarios'
                               ACT 'Actividad laboral'
                               HOR 'Horario de clase'.
VALUE LABELS ABA ACT 1 'No' 2 'S'/
                         HOR 1 'Maana' 2 'Tarde' 3 'Noche'.
FORMATS ABA ACT HOR (F1.0).
WEIGHT BY FRE.
CROSSTABS ABA BY ACT BY HOR.
* Tablas de contingencia bivariables i trivariables.
CROSSTABS ABA BY ACT /ABA BY HOR /HOR BY ACT 
 /ABA BY ACT BY HOR   /ABA BY HOR  BY ACT 
 /CELLS=COUNT COLUMN EXPECTED ASRESID
 /STATISTICS=CHISQ PHI
 /BARCHART.

* Seleccin de modelo. Anlisis log-lineal jerrquico con 2 y 3 variables.
HILOGLINEAR ABA ACT(1,2)
 /PRINT=ALL
 /DESIGN=ABA*ACT.
HILOGLINEAR ABA (1,2) HOR(1,3) ACT(1,2)
 /PRINT=ALL
 /METHOD=BACKWARD
 /DESIGN=ABA*HOR*ACT.

*  Anlisis log-lineal general del modelo saturado con 2 y 3 variables.
GENLOG  ABA ACT
  /MODEL=MULTINOMIAL 
  /PRINT = FREQ RESID ADJRESID ZRESID DEV DESIGN ESTIM CORR COV ITERATION
  /PLOT = RESID( ADJRESID DEV ) NORMPROB( ADJRESID DEV )
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(.5)
  /DESIGN =ABA BY ACT ABA ACT.
LOGLINEAR ABA ACT(1,2) HOR(1,3)
 /PRINT=ESTIM
 /DESIGN.
GENLOG  ABA ACT HOR
  /MODEL=MULTINOMIAL 
  /PRINT = FREQ RESID ADJRESID ZRESID DEV DESIGN ESTIM CORR COV ITERATION
  /PLOT = RESID( ADJRESID DEV ) NORMPROB( ADJRESID DEV )
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(.5)
  /DESIGN.

* 19 Modelos log-lineales con 3 variables. Clculo del ndice de disimilitud.
GENLOG ABA ACT HOR /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ZRESID ADJRESID DEV ESTIM /PLOT=NONE /DESIGN ABA
   /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL /PRINT=FREQ RESID ZRESID ADJRESID DEV ESTIM /PLOT=NONE /DESIGN ACT
   /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL /PRINT=FREQ RESID ZRESID ADJRESID DEV ESTIM /PLOT=NONE /DESIGN HOR
   /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ZRESID ADJRESID DEV ESTIM /PLOT=NONE /DESIGN ABA ACT 
   /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ZRESID ADJRESID DEV ESTIM /PLOT=NONE /DESIGN ABA HOR 
   /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ZRESID ADJRESID DEV ESTIM /PLOT=NONE /DESIGN ACT HOR 
   /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ZRESID ADJRESID DEV ESTIM /PLOT=NONE /DESIGN ABA ACT HOR 
   /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ZRESID ADJRESID DEV ESTIM /PLOT=NONE /DESIGN ABA*ACT
  /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ESTIM /PLOT=NONE /DESIGN ABA*ACT HOR
  /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ESTIM /PLOT=NONE /DESIGN ABA*HOR
  /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ESTIM /PLOT=NONE /DESIGN ABA*HOR ACT
  /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ESTIM /PLOT=NONE /DESIGN ACT*HOR
  /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ESTIM /PLOT=NONE /DESIGN ACT*HOR ABA
  /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ESTIM CORR /PLOT=NONE /DESIGN ABA ACT HOR ABA*ACT ABA*HOR
  /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
* Clculo del ndice de disimilitud.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

* Modelo 16.
GENLOG ABA ACT HOR 
  /MODEL=MULTINOMIAL  
  /PRINT=FREQ RESID ADJRESID DEV ZRESID ITERATION ESTIM COV CORR DESIGN
  /PLOT=RESID(ADJRESID DEV) NORMPROB(ADJRESID DEV)
  /DESIGN ABA ACT HOR ABA*ACT ACT*HOR
  /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ESTIM /PLOT=NONE /DESIGN ABA ACT HOR ABA*HOR ACT*HOR
  /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

GENLOG ABA ACT HOR /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ESTIM /PLOT=NONE /DESIGN ABA ACT HOR ABA*ACT ABA*HOR ACT*HOR
  /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.

* Modelo 19, modelo saturado.
GENLOG ABA ACT HOR 
  /MODEL=MULTINOMIAL  /PRINT=FREQ RESID ADJRESID DEV ZRESID ITERATION ESTIM COV CORR DESIGN
  /PLOT=RESID(ADJRESID DEV) NORMPROB(ADJRESID DEV)
  /DESIGN ABA ACT HOR ABA*ACT ACT*HOR ABA*HOR ABA*ACT*HOR
  /SAVE=RESID ZRESID ADJRESID DEV PRED.
* Clculo del ndice de disimilitud.
COMPUTE C=1.
COMPUTE ABS_RES_1=ABS(RES_1).
WEIGHT OFF.
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=C
  /ABS_RES_1_sum=SUM(ABS_RES_1) 
  /PRE_1_sum=SUM(PRE_1).
WEIGHT BY FRE.
COMPUTE ID=(ABS_RES_1_sum/(2*PRE_1_sum))*100.
LIST ID /CASES=FROM 1 TO 1.
DELETE VARIABLES RES_1 ZRE_1 ADJ_1 DEV_1 PRE_1 ABS_RES_1 ABS_RES_1_sum PRE_1_sum ID.


* Modelo 16. Estimacin de los parmetros del modelo no saturado de clase generadora:
  [ABA ACT]  [ACT HOR].
HILOGLINEAR  ABA(1 2) ACT(1 2) HOR(1 3)  /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(10) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID
  /PLOT=RESID NORMPROB
  /DESIGN ABA*ACT ACT*HOR.
LOGLINEAR ABA ACT(1,2) HOR(1,3)
 /PRINT=ESTIM
 /DESIGN=ABA BY ACT 
         ACT BY HOR 
         ABA 
         ACT 
         HOR.
GENLOG
  ABA ACT HOR
  /MODEL=MULTINOMIAL 
  /PRINT = FREQ RESID ADJRESID ZRESID DEV DESIGN ESTIM CORR COV ITERATION
  /PLOT = RESID( ADJRESID DEV ) NORMPROB( ADJRESID DEV )
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(.5)
  /DESIGN ABA ACT HOR ABA*ACT ACT*HOR.