# Data frame Actitud.rda
load("C:/Actitud.rda")

# Conversin de casos (data frame) a tabla
TC=table(actitud$ACT,actitud$EST,actitud$SEX,dnn=c("ACT","EST","SEX"))
TC

# Anlisis log-lineal
# Modelo saturado
MS=glm(Freq ~ ACT*EST*SEX, data=TC, family=poisson(link="log"))
summary(MS)
# Funcin step: seleccin de modelo
step(MS, direction="backward", test="Chisq")

# Modelo saturado: cambio de categora de referencia
MS=glm(Freq ~ relevel(ACT,2)*relevel(EST,3)*relevel(SEX,2), poisson, data=TCF)
summary(MS)
# Funcin step: seleccin de modelo
step(MS, direction="backward")

# Modelo homogneo
TC=table(actitud$ACT,actitud$EST,actitud$SEX,dnn=c("ACT","EST","SEX"))
TC
MS=glm(Freq ~ ACT*EST+ACT*SEX+EST*SEX, data=TC, family=poisson(link="log"))
step(MS, direction="backward", test="Chisq")


