TITLE Anlisis Log-lineal.

SET TNUMBERS=BOTH TVARS=BOTH ONUMBERS=BOTH OVARS=BOTH. 

*** Generacin e identificacin de los datos de la tabla de contingencia.
DATA LIST FREE/ EST ACT SEX FRE.
BEGIN DATA
1 1 1 72
1 2 1 47
2 1 1 110
2 2 1 196
3 1 1 44
3 2 1 179
1 1 2 86
1 2 2 38
2 1 2 173
2 2 2 283
3 1 2 28
3 2 2 187
END DATA.
VARIABLE LABELS EST "Nivel de estudios"
                               ACT "Actitud: permanencia de la mujer en el hogar"
                               SEX "Sexo".
VALUE LABELS EST 1 'Primarios' 2 'Secundarios' 3 'Superiores' /
                         ACT 1 "De acuerdo" 2 "En desacuerdo" /
                         SEX  1 'Varn' 2 'Mujer'.
FORMATS EST ACT SEX (F1.0).
WEIGHT BY FRE.

* Tablas de contingencia bivariables i trivariables.
CROSSTABS ACT BY EST SEX /EST  BY SEX /ACT BY EST BY SEX
    /STATISTICS=CHISQ PHI
    /CELLS= COUNT EXPECTED COLUMN ASRESID
    /BARCHART.

* Anlisis Log-lineal jerrquico: seleccin de modelo.
HILOGLINEAR  ACT(1 2) EST(1 3) SEX(1 2)  
  /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(10) P(.05) ITERATION(20) DELTA(.5)
  /PRINT= ALL
  /DESIGN .

* Anlisis Log-lineal: general.

* Procedimiento antiguo.
LOGLINEAR  ACT(1 2) EST(1 3) SEX(1 2)  
  /PRINT=FREQ RESID ESTIM
  /PLOT=RESID NORMPROB
  /DESIGN=ACT BY EST
                 EST BY SEX
                 ACT EST SEX.

* Procedimiento actual.
GENLOG
  EST ACT SEX
  /MODEL = MULTINOMIAL
  /PRINT = FREQ RESID ADJRESID ZRESID DEV DESIGN ESTIM CORR COV
  /PLOT = RESID( ADJRESID DEV ) NORMPROB( ADJRESID DEV )
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(.5)
  /DESIGN ACT EST SEX ACT*EST EST*SEX .

