
# Data frame Coche.rda
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/Coche.rda"))

library(Deducer)
tabla = contingency.tables(row.vars=d(Coche),col.vars=d(Clase),data=Coche)
tabla = add.chi.squared(tabla)
print(tabla,prop.r=T,prop.c=T,prop.t=T,expected.n=T,residuals=T,std.residuals=T,adj.residuals=T)

# Conversin de casos (data frame) a tabla
# Seleccionando las variables
TC=table(Coche$Coche,Coche$Clase,dnn=c("Coche","Clase"))
TC

# Anlisis log-lineal
# Modelo saturado con 2 variables
MS=glm(Freq ~ Coche*Clase, data=TC, family=poisson(link="log"))
summary(MS) # Resumen del objeto
names(MS)   # Contenido de MS
# Funcin step: seleccin de modelo
step(MS, direction="backward", test="Chisq")

# Modelo saturado: cambio de categora de referencia (la ltima en vez de la primera)
MS=glm(Freq ~ relevel(Coche,2)*relevel(Clase,3), data=TC, family=poisson(link="log"))
summary(MS)
step(MS, direction="backward", test="Chisq")
