# Data frame Ingresos.rda
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/Ingresos.rda"))

# Conversin de casos (data frame) a tabla
TC=table(Ingresos$ING,Ingresos$SEX,Ingresos$OCU,dnn=c("ING","SEX","OCU"))
TC

# Anlisis log-lineal
# Modelo saturado
MS=glm(Freq ~ ING*SEX*OCU, data=TC, family=poisson(link="log"))
summary(MS)
names(MS)
# Funcin step: seleccin de modelo
step(MS, direction="backward", test="Chisq")

# Modelo saturado: cambio de categora de referencia
MS=glm(Freq ~ relevel(ING,2)*relevel(SEX,2)*relevel(OCU,2), data=TC, family=poisson(link="log"))
summary(MS)
step(MS, direction="backward", test="Chisq")

