# Tabla de contingencia bivariable
# LLENGUA x EDAT con los datos del archivo Llengua.rda

# Creacin de la tabla de contingencia con "xtabs" del paquete "stats"
TC = xtabs(~ Llengua$LLENGUA + Llengua$EDAT)
TC
TC=table(Llengua$LLENGUA, Llengua$EDAT,dnn=c("LLENGUA","EDAT"))
TC

# Clculo de los odds ratio (OR) o razn de razones y de los logaritmos de los odds ratios (LOR) 
OR=loddsratio(~ Llengua$LLENGUA + Llengua$EDAT,ref=c(4,6),log=FALSE) # OR con las ltimas categoras como referencia
LOR=loddsratio(~ Llengua$LLENGUA + Llengua$EDAT,ref=c(4,6))          # LOR
summary(OR)
summary(LOR)
confint(OR)
confint(LOR)
plot(Llengua$LLENGUA, Llengua$EDAT)
plot(table(Llengua$LLENGUA, Llengua$EDAT,dnn=c("LLENGUA","EDAT")))
plot(OR)
plot(LOR)

x=subset(Llengua$LLENGUA + Llengua$EDAT,ref=c(4,6),log=FALSE))
plot(loddsratio(~ Llengua$LLENGUA + Llengua$EDAT,ref=c(4,6)))

plot(loddsratio(TC,ref=c(4,6),log=FALSE))


# Anlisis log-lineal
# Modelo saturado
MS=glm(Freq ~ LLENGUA*EDAT, data=TC, family=poisson(link="log"))
summary(MS)
# Funcin step: seleccin de modelo
step(MS, direction="backward", test="Chisq")
