# Data frame AMS_ECV2011.rda
load("D:/Datos/AMS_ECV2011.rda")
# Conversin de casos (data frame) a tabla
TC=table(AMS_ECV2011$O,AMS_ECV2011$D,AMS_ECV2011$S,dnn=c("O","D","S"))
# Anlisis log-lineal: modelo saturado
MS=glm(Freq ~ O*D*S, data=TC, family=poisson(link="log"))
summary(MS)
# Funcin step: seleccin de modelo a partir del modelo saturado
step(MS, direction="backward", test="Chisq")

# Conversin de casos (data frame) a tabla
TC=table(AMS_ECV2011$O,AMS_ECV2011$D,AMS_ECV2011$C,dnn=c("O","D","C"))
# Anlisis log-lineal: modelo saturado
MS=glm(Freq ~ O*D*C, data=TC, family=poisson(link="log"))
summary(MS)
# Funcin step: seleccin de modelo a partir del modelo saturado
step(MS, direction="backward", test="Chisq")
