TITLE Anlisis Log-lineal.

*  Ejemplo de clculo en un anlisis log-lineal
   100 casos: Usa ordenador habitualmente y Edad.

SET TNUMBERS=BOTH TVARS=BOTH ONUMBERS=BOTH OVARS=BOTH. 

*** Modelo constante.
DATA LIST FREE /ORD EDA FRE.
BEGIN DATA.
1 1 25
1 2 25
2 1 25
2 2 25
END DATA.
VARIABLE LABELS EDA 'Edad'
                               ORD "Usa ordenador habitualmente".
VALUE LABELS EDA 1 'Joven'   2 'Mayor'/
                         ORD 1 'S'   2 'No'.
FORMATS EDA ORD (F1.0).
WEIGHT BY FRE.
CROSSTABS ORD BY EDA /CELLS=COUNT EXP COL  /STAT=CHISQ PHI.

HILOGLINEAR ORD(1,2) EDA(1,2)
 /CRITERIA=DELTA(0)
 /PRINT=ALL
 /PLOT=ALL
 /DESIGN=ORD*EDA.

GENLOG
  ORD EDA
  /MODEL = MULTINOMIAL
  /PRINT = FREQ RESID DEV ADJRESID ESTIM CORR COV
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(0)
  /DESIGN .

*** Modelo [Y].
DATA LIST FREE /ORD EDA FRE.
BEGIN DATA.
1 1 30
1 2 30
2 1 20
2 2 20
END DATA.
VARIABLE LABELS EDA 'Edad'
                               ORD "Usa ordenador habitualmente".
VALUE LABELS EDA 1 'Joven'   2 'Mayor'/
                         ORD 1 'S'   2 'No'.
FORMATS EDA ORD (F1.0).
WEIGHT BY FRE.
CROSSTABS ORD BY EDA /CELLS=COUNT EXP COL  /STAT=CHISQ PHI.

HILOGLINEAR ORD(1,2) EDA(1,2)
 /CRITERIA=DELTA(0)
 /PRINT=ALL
 /PLOT=ALL
 /DESIGN=ORD.

LOGLINEAR ORD(1,2) EDA(1,2)
 /PRINT=ESTIM
 /CRITERIA=DELTA(0)
 /DESIGN ORD.

GENLOG
  ORD EDA
  /MODEL = MULTINOMIAL
  /PRINT = FREQ RESID DEV ADJRESID ESTIM CORR COV
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(0)
  /DESIGN ORD.

*** Modelo [X].
DATA LIST FREE /ORD EDA FRE.
BEGIN DATA.
1 1 30
1 2 20
2 1 30
2 2 20
END DATA.
VARIABLE LABELS EDA 'Edad'
                               ORD "Usa ordenador habitualmente".
VALUE LABELS EDA 1 'Joven'   2 'Mayor'/
                         ORD 1 'S'   2 'No'.
FORMATS EDA ORD (F1.0).
WEIGHT BY FRE.
CROSSTABS ORD BY EDA /CELLS=COUNT EXP COL  /STAT=CHISQ PHI.

HILOGLINEAR ORD(1,2) EDA(1,2)
 /CRITERIA=DELTA(0)
 /PRINT=ALL
 /PLOT=ALL
 /DESIGN=EDA.

LOGLINEAR ORD(1,2) EDA(1,2)
 /PRINT=ESTIM
 /CRITERIA=DELTA(0)
 /DESIGN EDA.

GENLOG
  ORD EDA
  /MODEL = MULTINOMIAL
  /PRINT = FREQ RESID DEV ADJRESID ESTIM CORR COV
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(0)
  /DESIGN=EDA.

*** Modelo [Y] [X].
DATA LIST FREE /ORD EDA FRE.
BEGIN DATA.
1 1 36
1 2 24
2 1 24
2 2 16
END DATA.
VARIABLE LABELS EDA 'Edad'
                               ORD "Usa ordenador habitualmente".
VALUE LABELS EDA 1 'Joven'   2 'Mayor'/
                         ORD 1 'S'   2 'No'.
FORMATS EDA ORD (F1.0).
WEIGHT BY FRE.
CROSSTABS ORD BY EDA /CELLS=COUNT EXP COL  /STAT=CHISQ PHI.

HILOGLINEAR ORD(1,2) EDA(1,2)
 /CRITERIA=DELTA(0)
 /PRINT=ALL
 /PLOT=ALL
 /DESIGN=ORD EDA.

LOGLINEAR ORD(1,2) EDA(1,2)
 /PRINT=ESTIM
 /CRITERIA=DELTA(0)
 /DESIGN ORD EDA.

GENLOG
  ORD EDA
  /MODEL = MULTINOMIAL
  /PRINT = FREQ RESID DEV ADJRESID ESTIM CORR COV
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(0)
  /DESIGN=ORD EDA.

*** Modelo [Y X].
DATA LIST FREE /ORD EDA FRE.
BEGIN DATA.
1 1 48
1 2 12
2 1 12
2 2 28
END DATA.
VARIABLE LABELS EDA 'Edad'
                               ORD "Usa ordenador habitualmente".
VALUE LABELS EDA 1 'Joven'   2 'Mayor'/
                         ORD 1 'S'   2 'No'.
FORMATS EDA ORD (F1.0).
WEIGHT BY FRE.
CROSSTABS ORD BY EDA 
 /CELLS=COUNT COLUMN EXPECTED RESID SRESID ASRESID 
 /STATISTICS=CHISQ PHI.

HILOGLINEAR ORD(1,2) EDA(1,2)
 /CRITERIA=DELTA(0)
 /PRINT=ALL
 /PLOT=ALL
 /DESIGN.

LOGLINEAR ORD(1,2) EDA(1,2)
 /PRINT=ESTIM
 /CRITERIA=DELTA(0)
/DESIGN ORD BY EDA ORD EDA.

GENLOG  ORD EDA
  /MODEL = MULTINOMIAL
  /PRINT = FREQ RESID DEV ADJRESID ESTIM CORR COV
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(0)
  /DESIGN ORD EDA ORD BY EDA .
