# Data frame Sentimiento.rda
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/Sentimiento.rda"))

# Conversin de casos (data frame) a tabla
TC=table(Sentimiento$SEN,Sentimiento$ING,Sentimiento$SEX,dnn=c("SEN","ING","SEX"))
TC

# Anlisis log-lineal: modelo saturado
MS=glm(Freq ~ SEN*ING*SEX, data=TC, family=poisson(link="log"))
summary(MS)
# Funcin step: seleccin de modelo a partir del modelo saturado
step(MS, direction="backward", test="Chisq")
# Anlisis log-lineal del modelo seleccionado: modelo de independencia parcial
MIP=glm(Freq ~ SEN + ING + SEX + ING:SEX, data=TC, family=poisson(link="log"))
summary(MIP)