TITLE Anlisis Log-lineal.

* Anlisis de la relacin entre Sentimiento nacionalista, Ingresos y Sexo.

SET TNUMBERS=BOTH TVARS=BOTH ONUMBERS=BOTH OVARS=BOTH.

GET  FILE='D:\Datos\CIS3041+.sav'.

RECODE P46 (1 THRU 4=1)(5 THRU 11=2)(MISSING=SYSMIS)  INTO ING.
VARIABLE LABELS  ING 'Nivel de ingresos'.
VALUE LABELS ING 1 'Bajo' 2 'Alto'.
FORMATS  ING (F1.0).
VARIABLE LEVEL  ING (ORDINAL).

RECODE P28 (MISSING=SYSMIS) (ELSE=COPY).
COMPUTE SEN=P28.
VARIABLE LABELS  SEN 'Sentimiento nacionalista'.
VALUE LABELS SEN 1 'Esp' 2 '+Esp' 3 'Igual' 4 '+CCAA' 5 'CCAA' 6 'Ninguna'.
FORMATS  SEN (F1.0).
VARIABLE LEVEL  SEN (ORDINAL).


VARIABLE LABELS  SEX 'Sexo'.

FREQUENCIES SEN  ING  SEX.

CROSSTABS SEN  BY ING  BY SEX 
    /STATISTICS=CHISQ PHI
    /CELLS= COUNT EXPECTED COLUMN ASRESID
    /BARCHART.

HILOGLINEAR SEN (1 6)  ING (1 2)  SEX (1 2) 
  /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(10) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION ESTIM
  /DESIGN.

SAVE OUTFILE='D:\Datos\Sentimiento.sav' /KEEP=SEN ING SEX.


