* Encoding: UTF-8.
TITLE Anlisis de regresin mltiple.

SET TNUMBERS=BOTH TVARS=BOTH ONUMBERS=BOTH OVARS=BOTH. 

GET FILE='D:\Datos\IDH2014.sav'.

CORRELATIONS  /VARIABLES=Lifeexpectancy Schooling GNIpercapita2011
  /STATISTICS DESCRIPTIVES XPROD.
GRAPH  /SCATTERPLOT(MATRIX)=Lifeexpectancy Schooling GNIpercapita2011.

* Transformacin de GNIpercapita2011.
COMPUTE LogGNI=LG10(GNIpercapita2011).
VARIABLE LABELS LogGNI 'Log(GNIpercapita2011)'.
CORRELATIONS  /VARIABLES=Lifeexpectancy Schooling LogGNI
  /STATISTICS DESCRIPTIVES XPROD.
GRAPH  /SCATTERPLOT(MATRIX)=Lifeexpectancy Schooling LogGNI.

*** REGRESIN LINEAL SIMPLE.

GRAPH  /SCATTERPLOT(BIVAR)=Schooling WITH Lifeexpectancy BY Country (IDENTIFY).
REGRESSION
  /DESCRIPTIVES MEAN STDDEV CORR SIG N
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS CI(95) R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN
  /DEPENDENT Lifeexpectancy
  /METHOD=ENTER Schooling
  /PARTIALPLOT ALL
  /SCATTERPLOT=(*ZRESID ,*ZPRED)
  /RESIDUALS HISTOGRAM(ZRESID) NORMPROB(ZRESID) ID(Country)
  /CASEWISE PLOT(ZRESID) OUTLIERS(3)
  /SAVE PRED(PRE1) ZPRED(ZPRE1) RESID(RES1) ZRESID(ZRES1) SRESID(SRES1).

GRAPH  /SCATTERPLOT(BIVAR)=GNIpercapita2011 WITH Lifeexpectancy BY Country (IDENTIFY).
REGRESSION
  /DESCRIPTIVES MEAN STDDEV CORR SIG N
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS CI(95) R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN
  /DEPENDENT Lifeexpectancy
  /METHOD=ENTER GNIpercapita2011
  /PARTIALPLOT ALL
  /SCATTERPLOT=(*ZRESID ,*ZPRED)
  /RESIDUALS HISTOGRAM(ZRESID) NORMPROB(ZRESID) ID(Country)
  /CASEWISE PLOT(ZRESID) OUTLIERS(3)
  /SAVE PRED(PRE2) ZPRED(ZPRE2) RESID(RES2) ZRESID(ZRES2) SRESID(SRES2).

GRAPH  /SCATTERPLOT(BIVAR)=LogGNI WITH Lifeexpectancy BY Country (IDENTIFY).
REGRESSION
  /DESCRIPTIVES MEAN STDDEV CORR SIG N
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS CI(95) R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN
  /DEPENDENT Lifeexpectancy
  /METHOD=ENTER LogGNI
  /PARTIALPLOT ALL
  /SCATTERPLOT=(*ZRESID ,*ZPRED)
  /RESIDUALS HISTOGRAM(ZRESID) NORMPROB(ZRESID) ID(Country)
  /CASEWISE PLOT(ZRESID) OUTLIERS(3)
  /SAVE PRED(PRE3) ZPRED(ZPRE3) RESID(RES3) ZRESID(ZRES3) SRESID(SRES3).

COMPUTE CASO=$CASENUM.
TEMPORARY. 
SELECT IF (SRES3<-3).
LIST CASO Country Lifeexpectancy GNIpercapita2011 LOGGNI.
TEMPORARY. 
SELECT IF (SRES3<-3).
LIST CASO Country PRE3 ZPRE3 RES3 ZRES3 SRES3.

* Seleccin de los casos con residuos studentizados que no superan +/- 3 unidades de desviacin.
TEMPORARY. 
SELECT IF (SRES3>-3).
REGRESSION
  /DESCRIPTIVES MEAN STDDEV CORR SIG N
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS CI(95) R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN
  /DEPENDENT Lifeexpectancy
  /METHOD=ENTER LogGNI
  /PARTIALPLOT ALL
  /SCATTERPLOT=(*ZRESID ,*ZPRED)
  /RESIDUALS HISTOGRAM(ZRESID) NORMPROB(ZRESID) ID(Country)
  /CASEWISE PLOT(ZRESID) OUTLIERS(3)
  /SAVE PRED(PRE4) ZPRED(ZPRE4) RESID(RES4) ZRESID(ZRES4) SRESID(SRES4).

*** REGRESIN LINEAL MLTIPLE.

GRAPH  /SCATTERPLOT(XYZ)=LogGNI WITH Lifeexpectancy WITH Schooling BY Country (IDENTIFY).
REGRESSION
  /DESCRIPTIVES MEAN STDDEV CORR SIG N
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS CI(95) R ANOVA COLLIN TOL ZPP
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT Lifeexpectancy
  /METHOD=ENTER LogGNI Schooling
  /PARTIALPLOT ALL
  /SCATTERPLOT=(*ZRESID ,*ZPRED)
  /RESIDUALS HISTOGRAM(ZRESID) NORMPROB(ZRESID) ID(Country)
  /CASEWISE PLOT(ZRESID) OUTLIERS(3)
  /SAVE PRED(PRE5) ZPRED(ZPRE5) RESID(RES5) ZRESID(ZRES5) SRESID(SRES5).

TEMPORARY. 
SELECT IF (SRES5>-3).
REGRESSION
  /DESCRIPTIVES MEAN STDDEV CORR SIG N
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS CI(95) R ANOVA COLLIN TOL ZPP
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT Lifeexpectancy
  /METHOD=ENTER LogGNI Schooling
  /PARTIALPLOT ALL
  /SCATTERPLOT=(*ZRESID ,*ZPRED)
  /RESIDUALS HISTOGRAM(ZRESID) NORMPROB(ZRESID) ID(Country)
  /CASEWISE PLOT(ZRESID) OUTLIERS(3)
  /SAVE PRED(PRE6) ZPRED(ZPRE6) RESID(RES6) ZRESID(ZRES6) SRESID(SRES6).


