* Encoding: UTF-8.
TITLE Anlisis de correlacin y regresin simple.

SET TNUMBERS=BOTH TVARS=BOTH ONUMBERS=BOTH OVARS=BOTH. 

DATA LIST FREE /V E I.

VAR LAB  V 'Valoracin del producto'
                E 'Edad'
                I 'Ingresos'.

BEGIN DATA
18 23  90
11 33 110
23 21  70
13 39 125
17 27 100
19 43 115
22 21  85
20 27  85
 9 43 150
14 38 130
21 30  75
11 54 145
 8 63 160
10 58 155
22 25  80
12 51 105
15 36 100
16 34 120
END DATA.

COMPUTE V2=V*V.
COMPUTE E2=E*E.
COMPUTE I2=I*I.
COMPUTE VE=V*E.
COMPUTE VI=V*I.
COMPUTE IE=I*E.

FORMATS V E (F2.0) I VE (F3.0) VI E2 (F4.0) I2 IE (F5.0).
VARIABLE LEVEL V E I (SCALE).

LIST VARIABLES=ALL.

DESCRIPTIVES V E I
  /STATISTICS=MEAN SUM STDDEV VARIANCE.
DESCRIPTIVES V2 E2 I2 VE VI IE
 /STATISTICS=SUM.

*** Regresiones simples.

* Grficos de dispersin.
GRAPH  /SCATTERPLOT(BIVAR)=E WITH V.
GRAPH  /SCATTERPLOT(BIVAR)=I WITH V.
GRAPH  /SCATTERPLOT(BIVAR)=E WITH I.

* Anlisis de correlacin.
CORRELATIONS V E I
 /STATISTICS DESCRIPTIVES XPROD.

* Anlisis de regresin simple.
REGRESSION VARIABLES=V I
  /STATISTICS COEFF OUTS CI(95) R ANOVA
  /DEPENDENT V
  /METHOD=ENTER I.

REGRESSION VARIABLES=V E
  /STATISTICS COEFF OUTS CI(95) R ANOVA
  /DEPENDENT V
  /METHOD=ENTER E.

REGRESSION VARIABLES=I E
  /STATISTICS COEFF OUTS CI(95) R ANOVA
  /DEPENDENT I
  /METHOD=ENTER E.

*** Regresin mltiple.

REGRESSION
  /DESCRIPTIVES MEAN STDDEV CORR SIG N
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS CI(95) BCOV R ANOVA COLLIN TOL CHANGE ZPP
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT V
  /METHOD=ENTER E I
  /RESIDUALS DURBIN
  /CASEWISE PLOT(ZRESID) OUTLIERS(3)
  /SAVE PRED ZPRED ADJPRED SEPRED MAHAL COOK LEVER RESID ZRESID SRESID DRESID SDRESID DFBETA SDBETA 
    DFFIT SDFIT COVRATIO.

* Linealidad y homoscedasticidad.
STATS REGRESS PLOT YVARS=RES_1 XVARS=I 
/OPTIONS CATEGORICAL=BARS GROUP=1 INDENT=15 YSCALE=75 
/FITLINES LINEAR APPLYTO=TOTAL.

* Autocorrelacin.
COMPUTE CASO=$casenum.
STATS REGRESS PLOT YVARS=RES_1 XVARS=CASO 
/OPTIONS CATEGORICAL=BARS GROUP=1 INDENT=15 YSCALE=75 
/FITLINES APPLYTO=TOTAL.


