TITLE Anlisis de regresin logstica binaria.

* Ejemplo extrado de: PARDO, A.; RUIZ, M.A. (2002). Gua para el anlisis de datos. Madrid: McGraw-Hill. Cap. 28
  con datos de la matriz GSS1993.sav.

GET FILE='GSS1993.sav'.

SET TNUMBERS=BOTH TVARS=BOTH ONUMBERS=BOTH OVARS=BOTH. 

FREQUENCIES VOTO DIARIOS.

*** Tabla de contingencia.
CROSSTABS VOTO BY DIARIOS /CELLS=COUNT COL /STAT=CHISQ PHI.

*** Regresiones logsticas.

* Regresin logstica binaria simple: variable categrica dicotmica.
LOGISTIC REGRESSION  VOTO
  /METHOD = ENTER DIARIOS
  /CRITERIA = PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

* Regresin logstica binaria simple: variable cuantitativa.
LOGISTIC REGRESSION  VOTO
  /METHOD = ENTER EDUC
  /CRITERIA = PIN(.05) POUT(.10) ITERATE(20) CUT(.5).
LOGISTIC REGRESSION VARIABLES VOTO
  /METHOD=ENTER EDUC 
  /SAVE=PRED(PRED1) PGROUP(PGR1) LRESID(LRESID1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).
GRAPH
  /SCATTERPLOT(BIVAR)=EDUC WITH PRE1 BY PGR1
  /MISSING=LISTWISE.
STATS REGRESS PLOT YVARS=PRE1 XVARS=EDUC COLOR=PGR1 
/OPTIONS CATEGORICAL=BARS GROUP=1 BOXPLOTS INDENT=15 YSCALE=75 
/FITLINES APPLYTO=TOTAL.

* Regresin logstica binaria mltiple: variable dicotmica y cuantitativa.
LOGISTIC REGRESSION  VOTO
  /METHOD = ENTER EDUC DIARIOS
  /PRINT=CI(95) GOODFIT
  /SAVE=PRED(PRED2) PGROUP(PGR2) LRESID(LRESID2)
  /CRITERIA = PIN(.05) POUT(.10) ITERATE(20) CUT(.5).


* Regresin logstica binaria mltiple. Mtodo de paso nico.
FREQUENCIES DIARIOS edad hijos EDUC ingfam91.
LOGISTIC REGRESSION  VOTO
  /METHOD = ENTER DIARIOS edad hijos EDUC ingfam91
  /PRINT=CI(95) GOODFIT
  /CRITERIA = PIN(.05) POUT(.10) ITERATE(20) CUT(.5) .

* Regresin logstica binaria mltiple. Mtodo de paso nico. Variables estandarizadas.
DESCRIPTIVES  VARIABLES=VOTO DIARIOS DIARIOS edad hijos EDUC ingfam91  /SAVE
  /STATISTICS=MEAN STDDEV MIN MAX .
LOGISTIC REGRESSION  zVOTO
  /METHOD = ENTER ZDIARIOS Zedad Zhijos ZEDUC Zingfam91
  /CRITERIA = PIN(.05) POUT(.10) ITERATE(20) CUT(.5) .

* Regresin logstica binaria mltiple. Mtodo por pasos: hacia delante condicional.
LOGISTIC REGRESSION  VOTO
  /METHOD = FSTEP(COND) DIARIOS edad hijos EDUC ingfam91
  /PRINT=GOODFIT
  /CRITERIA = PIN(.05) POUT(.10) ITERATE(20) CUT(.5) .

* Regresin logstica binaria mltiple. Definicin de contrastes con variables categricas: indicador.
FREQUENCIES titestud.
CROSSTABS VOTO BY titestud /CELLS=COUNT COL /STAT=CHISQ PHI.
LOGISTIC REGRESSION  VOTO
  /METHOD = ENTER titestud
  /CONTRAST (titestud)=Indicator
  /PRINT=GOODFIT
  /CRITERIA = PIN(.05) POUT(.10) ITERATE(20) CUT(.5) .

* Regresin logstica binaria mltiple.  Definicin de contrastes con variables categricas: simple.
LOGISTIC REGRESSION  VOTO
  /METHOD = ENTER titestud
  /CONTRAST (titestud)=Simple
  /CRITERIA = PIN(.05) POUT(.10) ITERATE(20) CUT(.5) .

* Regresin logstica binaria mltiple. Definicin de contrastes con variables categricas: deviation.
LOGISTIC REGRESSION  VOTO
  /METHOD = ENTER titestud
  /CONTRAST (titestud)=Deviation(1)
  /CRITERIA = PIN(.05) POUT(.10) ITERATE(20) CUT(.5) .

* Regresin logstica binaria mltiple. Modelo con cualitativas y cuantitativas.
* Pronsticos y residuos. Grficos.
FREQUENCIES  titestud indsocec.
LOGISTIC REGRESSION  VOTO
  /METHOD = ENTER DIARIOS edad titestud indsocec
  /CONTRAST (titestud)=Indicator
  /SAVE = PRED PGROUP COOK LEVER DFBETA 
          RESID LRESID SRESID ZRESID DEV
  /CRITERIA = PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

DESCRIPTIVES
  VARIABLES=PRE_1 PGR_1 ZRE_1
  /STATISTICS=MEAN STDDEV MIN MAX .
FREQUENCIES PGR_1.

* Grficos de residuos.
STATS REGRESS PLOT YVARS=ZRE_1 XVARS=edad indsocec COLOR=PGR_1
/OPTIONS CATEGORICAL=BARS GROUP=1 INDENT=15 YSCALE=75
/FITLINES APPLYTO=TOTAL.

* Grficos de probabilidad pronosticada.
STATS REGRESS PLOT YVARS=PRE_1 XVARS=edad indsocec COLOR=PGR_1
/OPTIONS CATEGORICAL=BARS GROUP=1 INDENT=15 YSCALE=75
/FITLINES APPLYTO=TOTAL.

* Grfico de la relacin entre la variable dependiente y las independientes.
* Codificacin dummy.
COMPUTE titestud0=0.
COMPUTE titestud1=0.
COMPUTE titestud2=0.
COMPUTE titestud3=0.
IF (titestud=0) titestud0=1.
IF (titestud=1) titestud1=1.
IF (titestud=2) titestud2=1.
IF (titestud=3) titestud3=1.
COMPUTE Pronosticolineal=0.29096647152286126 + 0.8060689423239916*DIARIOS - 0.03316771369071259*edad 
+ 1.8493584873660927*titestud0 + 0.8918110537746985*titestud1 + 0.1293388885861294*titestud2
+ -0.1413725157952574*titestud3 - 0.01624182868843997*indsocec.
COMPUTE PrY1=1/(1+EXP(-Pronosticolineal)).
COMPUTE PrY0=1-(1/(1+EXP(-Pronosticolineal))).
COMPUTE razones=PrY1/PrY0.
COMPUTE logit=ln(PrY1/PrY0).
COMPUTE residuo=VOTO-PRE_1.
COMPUTE malclasificado=VOTO-PGR_1.
VALUE LABELS malclasificado -1 'De 0 a 1' 0 'Bien clasificado' 1 'De 1 a 0'.

GRAPH  /SCATTERPLOT(BIVAR)=Pronosticolineal WITH PRE_1 BY PGR_1.

* Regresin logstica binaria mltiple. Opciones adicionales.
LOGISTIC REGRESSION VARIABLES VOTO
  /METHOD=ENTER DIARIOS edad titestud indsocec 
  /CONTRAST (titestud)=Indicator
  /CLASSPLOT
  /CASEWISE OUTLIER(2)
  /PRINT=GOODFIT CORR ITER(1) CI(95)
  /CRITERIA=PIN(0.05) POUT(0.10) ITERATE(20) CUT(0.5).

* Eliminacin de residuos extremos.
SELECT IF (ZRE_1 < 3).
LOGISTIC REGRESSION VARIABLES VOTO
  /METHOD=ENTER DIARIOS edad titestud indsocec 
  /CONTRAST (titestud)=Indicator.

* Cambio del punto de corte.
LOGISTIC REGRESSION VARIABLES VOTO
  /METHOD=ENTER DIARIOS edad titestud indsocec 
  /CONTRAST (titestud)=Indicator
  /SAVE = PRED (PREDIC)
  /CRITERIA=PIN(0.05) POUT(0.10) ITERATE(20) CUT(0.5).

ROC PREDIC BY VOTO (1)
  /PLOT=CURVE(REFERENCE)
  /PRINT=SE COORDINATES
  /CRITERIA=CUTOFF(INCLUDE) TESTPOS(LARGE) DISTRIBUTION(FREE) CI(95)
  /MISSING=EXCLUDE.

LOGISTIC REGRESSION VARIABLES VOTO
  /METHOD=ENTER DIARIOS edad titestud indsocec 
  /CONTRAST (titestud)=Indicator
  /CRITERIA=PIN(0.05) POUT(0.10) ITERATE(20) CUT(0.3).

*************************************************************************.
* Propuesta de ejercicio con esta base de datos: analizar la variable dependiente "deportes".
* Abrir de nuevo la base de datos.
GET FILE='GSS1993.sav'.
FREQUENCIES deportes.
* Posibles variables independientes.
MISSING VALUES CASAPROP (3).
FREQUENCIES deportes DIARIOS SEXO EDAD EDADCAT4 INGRESO4 INGRESO3 EDUC TITESTU2 RAZA raza2 actividad MUSEOS 
											 INDSOCEC HORASTV REGIN4 CASADO HIJOS TITESTU2 INGRESO4 politica2 VOTO CASAPROP VIDA.

*************************************************************************.
* Instrucciones alternativas para la creacin de variables dummies con SPSS.
* Si consideramos la variable "relig" que tiene 5 categoras (con valores 1 a 5) precisamos 4 variables dummies.
VECTOR dummy(4).
LOOP #i = 1 to 4.
COMPUTE dummy(#i) = (relig = #i).
END LOOP.
EXECUTE.




