# Matriz de datos ejemplo sobre segmentacin del mercado de trabajo: Segmenta.rda
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/Coche.rda"))
attach(Coche)

# Paquetes adicionales para la regresin logstica
install.packages("fmsb") # Funciones adicionales
library(fmsb)
install.packages("rcompanion") # Funciones adicionales
library(rcompanion)
install.packages("blorr") # Modelos de ARL binaria: https://blorr.rsquaredacademy.com/
library(blorr)

############## Anlisis de regresin logstica binaria simple

# Tabla de contingencia entre VOTO y DIARIOS
library (Deducer)
TC = contingency.tables(row.vars=d(Coche),col.vars=d(Clase),data=Coche)
TC = tables<-add.chi.squared(TC)
TC = print(tables,prop.r=F,prop.c=T,prop.t=F)

# Para ver la codificacin dummy y ver cmo interpretar el modelo
contrasts(Coche$Coche)
contrasts(Coche$Clase)

# ARL binaria simple
ARLog = glm(Coche ~ Clase, family=binomial(link='logit'), data=Coche, na.action=na.omit)
summary(ARLog)

# ARL binaria simple cambiando la categora de referencia
ARLog = glm(relevel(Coche,"No") ~ relevel(Clase,"Baja"), family=binomial(link='logit'), data=Coche, na.action=na.omit)
summary(ARLog)
# Intervalos de confianza de los coeficientes
confint(ARLog)
# Exponencial de los coeficientes: modelo multiplicativo
exp(coef(ARLog))
exp(confint(ARLog))
# Bondad de ajuste del modelo
NagelkerkeR2(ARLog)

