# Tabla de contingencia tridimensonal
# ABA x ACT X HOR con los datos del archivo Abandono.rda

# Para ejecutar el script en R o RStudio es necesario tener instalado el paquete Deducer
# Tambin el paquete vcd
install.packages("vcd")
library(vcd)

# Tabla ABA x ACT X HOR con las frecuencias 
ABA3<-contingency.tables(row.vars=d(ABA),col.vars=d(ACT),stratum.var=HOR,
                         data=abandono)
print(ABA3,prop.r=F,prop.c=F,prop.t=F)

# Tablas ABA x ACT y ABA x HOR 
ABA1<-contingency.tables(row.vars=d(ABA),col.vars=d(ACT,HOR),data=abandono)
ABA1<-add.chi.squared(ABA1)
print(ABA1,prop.r=T,prop.c=T,prop.t=F,expected.n=T,adj.residuals=T)
ggplot() + geom_bar(aes(y = ..count..,x = ACT,fill = ABA),data=abandono,position = position_fill())
ggplot() + geom_bar(aes(y = ..count..,x = HOR,fill = ABA),data=abandono,position = position_fill())
assocstats(table(abandono$ABA, abandono$ACT))
assocstats(table(abandono$ABA, abandono$HOR))

# Tabla ACT x HOR 
ABA2<-contingency.tables(row.vars=d(ACT),col.vars=d(HOR),data=abandono)
ABA2<-add.chi.squared(ABA2)
print(ABA2,prop.r=T,prop.c=T,prop.t=F,expected.n=T,adj.residuals=T)
ggplot() + geom_bar(aes(y = ..count..,x = HOR,fill = ACT),data=abandono,position = position_fill())
assocstats(table(abandono$ACT, abandono$HOR))

# Tabla ABA x ACT x HOR 
ABA3<-add.chi.squared(ABA3)
print(ABA3,prop.r=T,prop.c=T,prop.t=F,expected.n=T,adj.residuals=T)
ggplot() + geom_bar(aes(y = ..count..,x = ACT,fill = ABA),data=abandono,position = position_fill()) +
           facet_wrap(facets = ~HOR) + ggtitle(label = 'HOR')
summary(subset(abandono,subset=HOR=="Maana"))
HOR1=subset(abandono,subset=HOR=="Maana")
assocstats(table(HOR1$ABA, HOR1$ACT))
summary(subset(abandono,subset=HOR=="Tarde"))
HOR2=subset(abandono,subset=HOR=="Tarde")
assocstats(table(HOR2$ABA, HOR2$ACT))
summary(subset(abandono,subset=HOR=="Noche"))
HOR3=subset(abandono,subset=HOR=="Noche")
assocstats(table(HOR3$ABA, HOR3$ACT))

# Tabla ABA x HOR x ACT 
ABA4<-contingency.tables(row.vars=d(ABA),col.vars=d(HOR),stratum.var=ACT,data=abandono)
ABA4<-add.chi.squared(ABA4)
print(ABA4,prop.r=T,prop.c=T,prop.t=F,expected.n=T,adj.residuals=T)
ggplot() + geom_bar(aes(y = ..count..,x = HOR,fill = ABA),data=abandono,position = position_fill()) +
           facet_wrap(facets = ~ACT) + ggtitle(label = 'ACT')
summary(subset(abandono,subset=ACT=="No"))
ACT1=subset(abandono,subset=ACT=="No")
assocstats(table(ACT1$ABA, ACT1$HOR))
summary(subset(abandono,subset=ACT=="S"))
ACT2=subset(abandono,subset=ACT=="S")
assocstats(table(ACT2$ABA, ACT2$HOR))

# Obtencin solamente de la V de Cramer de todas las tablas
assocstats(table(abandono$ABA, abandono$ACT))
assocstats(table(abandono$ABA, abandono$HOR))
assocstats(table(abandono$ACT, abandono$HOR))
HOR1=subset(abandono,subset=HOR=="Maana")
assocstats(table(HOR1$ABA, HOR1$ACT))
HOR2=subset(abandono,subset=HOR=="Tarde")
assocstats(table(HOR2$ABA, HOR2$ACT))
HOR3=subset(abandono,subset=HOR=="Noche")
assocstats(table(HOR3$ABA, HOR3$ACT))
ACT1=subset(abandono,subset=ACT=="No")
assocstats(table(ACT1$ABA, ACT1$HOR))
ACT2=subset(abandono,subset=ACT=="S")
assocstats(table(ACT2$ABA, ACT2$HOR))

# Instrucciones adicionales para generar el Data frame a partir de las frecuencias
abandono = data.frame(
  ABA=factor(rep(1:2, c(367,107)), labels=c("No","S")),
  ACT=factor(c(rep(1:2, c(245,122)), rep(1:2, c(45,62))), labels=c("No","S")),
  HOR=factor(c(rep(1:3, c(100,70,75)), rep(1:3, c(17,50,55)),
               rep(1:3, c(10,25,10)), rep(1:3, c(7,20,35))), labels=c("Maana","Tarde","Noche")) )
save(abandono,file='D:/Datos/Abandono.rda')

