# Tabla de contingencia bivariable: Posesin de coche y Clase social

##### Procedimiento 1. Con los datos del archivo Coche.rda
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/Coche.rda"))

# Instrucciones para ejecutar desde la consola de Deducer, o bien desde R o RStudio teniendo  
# instalado el paquete "Deducer"
# install.packages("Deducer") 
library(Deducer)
tabla = contingency.tables(row.vars=d(Coche),col.vars=d(Clase),data=Coche)
tabla = add.chi.squared(tabla)
print(tabla,prop.r=T,prop.c=T,prop.t=T,expected.n=T,residuals=T,std.residuals=T,adj.residuals=T) 

# Grfico de barras apiladas al 100%
ggplot() + geom_bar(aes(y = ..count..,x=Clase, fill=Coche), data=Coche, position=position_fill()) +
           scale_y_continuous(labels=scales::percent) + ylab ("%") 

# Para obtener la V de Cramer con el paquete "vcd" ejecutando "assocstats"
# install.packages("vcd") 
library(vcd)
assocstats(table(Coche$Coche, Coche$Clase))

# Alternativamente se puede crear una tabla y usar la funcin "cramer" del paquete "treeClust"
# Primero es preciso crear la tabla de contingencia, p. ej. con "xtabs" del paquete "stats"
tabla2 = xtabs(~ Coche$Coche + Coche$Clase)
tabla2
# Funcin "cramer" del paquete "treeClust"
# install.packages("treeClust") 
library(treeClust)
cramer(tabla2)


##### Procedimiento 2. Paquete gmodels para obtener la tabla y la prueba de Chi-cuadrado
# install.packages("gmodels") 
library(gmodels)
CrossTable(Coche$Coche, Coche$Clase, prop.t=TRUE, prop.r=TRUE, prop.c=TRUE, chisq=TRUE, fisher=TRUE, 
           resid=TRUE, sresid=TRUE, asresid=TRUE, format="SPSS")


##### Procedimiento 3. Introduccin de los datos y anlisis de la tabla Posesin de coche y Clase social
tabla=as.table(matrix(c(650,64,1234,333,1430,1036),nrow=2,ncol=3))
dimnames(tabla)=list(c("S","No"),c("Alta","Media","Baja"))
names(dimnames(tabla))=c("Coche","Clase")
tabla

# Las funciones siguientes tambin etiquetan las filas y columnas:
# rownames(tabla)=c("S","No")
# colnames(tabla)=c("Alta","Media","Baja")

prop.table(tabla) # proporcin total
prop.table(tabla,1) # proporcin fila
prop.table(tabla,2) # proporcin columna
round(prop.table(tabla,2)*100,1) # % columna con 1 decimal
margin.table(tabla) # marginal total
margin.table(tabla,1) # marginal de fila
margin.table(tabla,2) # marginal de columna
addmargins(tabla, margin=1) # Se aade marginal de fila
addmargins(tabla, margin=2) # Se aade marginal de columna
addmargins(tabla) # Se aaden marginal de fila y columna
addmargins(round(prop.table(tabla)*100,1)) # % total con marginal de fila y columna

# Grfico de barras
barplot(round(prop.table(tabla,2)*100,1),legend=TRUE,
        xlab="Clase social",main="Posesin de coche")
chisq.test(tabla)
summary(tabla)

# Conversin de la tabla a Data Frame (inversa de xtabs)
x=as.data.frame(tabla)
x


##### Procedimiento 4. Introduccin de la tabla como Data Frame
Coche=c("S","No")
Clase=c("Alta","Media","Baja")
Fre=c(650,64,1234,333,1430,1036)
matriz=data.frame(Coche,Clase,Fre)
matriz


