TITLE Anlisis Log-lineal.

* Tabla de contingencia entre la posesin de coche y la clase social.

DATA LIST FREE / Coche Clase FRE.
BEGIN DATA
1 1 650
1 2 1234
1 3 1430
2 1 64
2 2 333
2 3 1036
END DATA.

VARIABLE LABELS Coche 'Posesin de coche'
                               Clase 'Clase social'
           .
VALUE LABELS  Coche 1 ' S'  2 ' No'
                          /Clase 1 'Alta' 2 'Media' 3 'Baja'.
FORMATS Coche Clase (F1.0).
LIST Coche Clase FRE.
FREQUENCIES Coche Clase FRE.
WEIGHT BY FRE.
FREQUENCIES Coche Clase FRE.

*** Tablas de contingencia: "General Mode".
CROSSTABS Coche BY Clase
 /CELLS=COUNT COLUMN.
CROSSTABS Coche BY Clase
 /CELLS=ALL
 /STATISTICS=ALL.
CROSSTABS Coche BY Clase
 /CELLS=COUNT ROW COLUMN TOTAL.
CROSSTABS Coche BY Clase
 /CELLS=COUNT EXPECTED RESID.
CROSSTABS
  /TABLES=Coche BY Clase
  /FORMAT=AVALUE TABLES
  /CELLS=COUNT
  /COUNT ROUND CELL
  /BARCHART.
CROSSTABS
  /TABLES=Coche BY Clase
  /FORMAT=AVALUE TABLES
  /CELLS=COUNT COLUMN PROP 
  /COUNT ROUND CELL.

* Generador de grficos.
GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=Clase COUNT()[name="COUNT"] Coche MISSING=LISTWISE 
    REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: Clase=col(source(s), name("Clase"), unit.category())
  DATA: COUNT=col(source(s), name("COUNT"))
  DATA: Coche=col(source(s), name("Coche"), unit.category())
  GUIDE: axis(dim(1), label("Categora socioeconmica"))
  GUIDE: axis(dim(2), label("Porcentaje"))
  GUIDE: legend(aesthetic(aesthetic.color.interior), label("Posesin de coche"))
  SCALE: cat(dim(1), include("1", "2", "3"))
  SCALE: linear(dim(2), include(0))
  SCALE: cat(aesthetic(aesthetic.color.interior), include("1", "2"))
  ELEMENT: interval.stack(position(summary.percent(Clase*COUNT, base.coordinate(dim(1)))), 
    color.interior(Coche), shape.interior(shape.square))
END GPL.

*** Tablas de contingencia: "Integer Mode".
MISSING VALUES Clase(2).
CROSSTABS VAR=Coche(1,2) Clase(1,3)
 /TABLES=Coche BY Clase
 /MISSING=REPORT
 /FORMAT=NOBOX
 /CELLS=COUNT COL
 /STATISTICS=CHISQ PHI CC.

*** Tablas de contingencia: Presentacin-TABLES.
MISSING VALUES Clase().
VARIABLE LABELS Coche ''.
TABLES FORMAT=CWIDTH(20,10) ZERO LIGHT
 /FTOTAL=T1 'TOTAL'
 /TABLE=Coche + T1 BY Clase + T1
 /STATISTICS=CPCT(Coche(PCT5.1)'':Clase)
             CPCT(T1(PCT5.1)'':Clase)
             COUNT(Coche(PAREN6.0)'')
             COUNT(T1(PAREN6.0)'')
 /TTITLE=LEFT"Tabla 1. Posesin de coche segn la categora socioeconmica"
 /TFOOTNOTE=LEFT"Los datos no incluyen ni los NS/NC ni los que"
                "han declarado 'No tiene categora'"
 /CORNER=" " " Posesin" " de coche".
