TITLE Tablas de contingencia, log-lineal y correspondencias.

SET TNUMBERS=BOTH TVARS=BOTH ONUMBERS=BOTH OVARS=BOTH.

GET  FILE='D:\Datos\CIS3041+.sav'.

* Recodificacin de los ingresos.
FREQUENCIES P46.
RECODE P46 (1=0)(2=150)(3=450)(4=750)(5=1050)(6=1500)(7=2100)(8=2700)(9=3750)(10=5250)(11=7500)(MISSING=9999)  INTO P46m.
VARIABLE LABELS  P46m 'Ingresos personales'.
VALUE LABELS P46m 9999 'NC'.
MISSING VALUES P46m(9999).
FORMATS  P46m (F2.0).
VARIABLE LEVEL  P46m (SCALE).
FREQUENCIES P46m /STATISTICS ALL.
EXAMINE P46m.

RECODE P46 (1 THRU 4=1)(5 THRU 11=2)(MISSING=3)  INTO Ingresos.
VARIABLE LABELS  Ingresos 'Nivel de ingresos'.
VALUE LABELS Ingresos 1 'Bajo' 2 'Alto' 3 'NC'.
MISSING VALUES Ingresos (3).
FORMATS  Ingresos (F1.0).
VARIABLE LEVEL  Ingresos (ORDINAL).

RECODE Ocupacin (1 THRU 2=2)(3 THRU 4=1)(MISSING=3)  INTO Ocupacin2.
VARIABLE LABELS  Ocupacin2 'Nivel ocupacional'.
VALUE LABELS Ocupacin2 1 'Bajo' 2 'Alto' 3 'NC'.
MISSING VALUES Ocupacin2 (3).
FORMATS  Ocupacin2 (F1.0).
VARIABLE LEVEL  Ocupacin2 (ORDINAL).
FREQUENCIES Ocupacin Ocupacin2 P46 Ingresos P31.

VARIABLE LABELS  P31 'Sexo'.

CROSSTABS Ingresos BY P31 Ocupacin2
                    /Ocupacin2  BY P31 
                    /Ingresos  BY Ocupacin2  BY P31
                    /Ingresos  BY P31 BY Ocupacin2 
                    /Ocupacin2  BY P31 BY Ingresos
    /STATISTICS=CHISQ PHI
    /CELLS= COUNT EXPECTED COLUMN ASRESID
    /BARCHART.

CROSSTABS Ingresos BY P31 Ocupacin
                    /Ocupacin  BY P31 
                    /Ingresos  BY Ocupacin  BY P31
                    /Ingresos  BY P31 BY Ocupacin
    /STATISTICS=CHISQ PHI
    /CELLS= COUNT EXPECTED COLUMN ASRESID
    /BARCHART.

CROSSTABS Ingresos BY P31 OCUMAR11
                    /OCUMAR11  BY P31 
                    /Ingresos  BY OCUMAR11  BY P31
                    /Ingresos  BY P31 BY OCUMAR11
    /STATISTICS=CHISQ PHI
    /CELLS= COUNT EXPECTED COLUMN ASRESID
    /BARCHART.

HILOGLINEAR Ingresos(1 2) P31(1 2) Ocupacin2(1 2) 
  /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(10) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION
  /DESIGN.


*************

CROSSTABS
  /TABLES=Ocupacin BY ESTUDIOS
  /FORMAT=AVALUE TABLES
  /CELLS=COUNT COLUMN 
  /COUNT ROUND CELL
  /BARCHART.

* Identificacin de los datos de la tabla.
DATA LIST FREE / Edad Sexo Frecuencia.
BEGIN DATA.
1	1	85,9
2	1	341,4
3	1	357,2
4	1	350,4
5	1	359,2
6	1	343,1
7	1	329,9
8	1	291,7
9	1	263,4
10	1	96,1
11	1	5,3
1	2	82,2
2	2	304,2
3	2	324,6
4	2	348,3
5	2	366,5
6	2	376,9
7	2	320,6
8	2	261,5
9	2	177,3
10	2	69,6
11	2	2,3
END DATA.

VARIABLE LABELS 	Edad 'Edad de la persona parada'
                		              Sexo 'Sexo de la persona parada'.
VALUE LABELS Edad  1 'De 16 a 19 aos'     2 'De 20 a 24 aos'     3 'De 25 a 29 aos'
                                   4 'De 30 a 34 aos'     5 'De 35 a 39 aos'     6 'De 40 a 44 aos'
                                   7 'De 45 a 49 aos'     8 'De 50 a 54 aos'     9 'De 55 a 59 aos'
                                 10 'De 60 a 64 aos'    11 'De 65 y ms aos'
    /Sexo 1 'Hombres' 2 'Mujeres'.
FORMATS Edad (F2.0) Sexo (F1.0).
WEIGHT BY Frecuencia.
FREQUENCIES ALL.
CROSSTABS Edad  BY Sexo
   /CELLS= COUNT COLUMN
   /BARCHART.





