TITLE Anlisis de tablas de contingencia.

* Anlisis de la relacin entre Ingresos, Sexo y Ocupacin.

SET TNUMBERS=BOTH TVARS=BOTH ONUMBERS=BOTH OVARS=BOTH.

GET  FILE='D:\Datos\CIS3041+.sav'.

* Recodificacin de los ingresos.
FREQUENCIES P46.
RECODE P46 (1=0)(2=150)(3=450)(4=750)(5=1050)(6=1500)(7=2100)(8=2700)(9=3750)(10=5250)(11=7500)(MISSING=9999)  INTO P46m.
VARIABLE LABELS  P46m 'Ingresos personales'.
VALUE LABELS P46m 9999 'NC'.
MISSING VALUES P46m(9999).
FORMATS  P46m (F2.0).
VARIABLE LEVEL  P46m (SCALE).
FREQUENCIES P46m /STATISTICS ALL.
EXAMINE P46m.

RECODE P46 (1 THRU 4=1)(5 THRU 11=2)(MISSING=3)  INTO Ingresos.
VARIABLE LABELS  Ingresos 'Nivel de ingresos'.
VALUE LABELS Ingresos 1 'Bajo' 2 'Alto' 3 'NC'.
MISSING VALUES Ingresos (3).
FORMATS  Ingresos (F1.0).
VARIABLE LEVEL  Ingresos (ORDINAL).

RECODE Ocupacin (1 THRU 2=2)(3 THRU 4=1)(MISSING=3)  INTO Ocupacin2.
VARIABLE LABELS  Ocupacin2 'Nivel ocupacional'.
VALUE LABELS Ocupacin2 1 'Bajo' 2 'Alto' 3 'NC'.
MISSING VALUES Ocupacin2 (3).
FORMATS  Ocupacin2 (F1.0).
VARIABLE LEVEL  Ocupacin2 (ORDINAL).
FREQUENCIES Ocupacin Ocupacin2 P46 Ingresos P31.

VARIABLE LABELS  P31 'Sexo'.

CROSSTABS Ingresos BY P31 Ocupacin2
                    /Ocupacin2  BY P31 
                    /Ingresos  BY Ocupacin2  BY P31
                    /Ingresos  BY P31 BY Ocupacin2 
                    /Ocupacin2  BY P31 BY Ingresos
    /STATISTICS=CHISQ PHI
    /CELLS= COUNT EXPECTED COLUMN ASRESID
    /BARCHART.

CROSSTABS Ingresos BY P31 Ocupacin
                    /Ocupacin  BY P31 
                    /Ingresos  BY Ocupacin  BY P31
                    /Ingresos  BY P31 BY Ocupacin
    /STATISTICS=CHISQ PHI
    /CELLS= COUNT EXPECTED COLUMN ASRESID
    /BARCHART.

CROSSTABS Ingresos BY P31 OCUMAR11
                    /OCUMAR11  BY P31 
                    /Ingresos  BY OCUMAR11  BY P31
                    /Ingresos  BY P31 BY OCUMAR11
    /STATISTICS=CHISQ PHI
    /CELLS= COUNT EXPECTED COLUMN ASRESID
    /BARCHART.

