# Tabla de contingencia bivariable
# LLENGUA x EDAT con los datos del archivo Llengua.rda
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/Llengua.rda"))

# Instrucciones para ejecutar desde la consola de Deducer, o bien desde R o RStudio teniendo  
# instalado el paquete "Deducer"
# install.packages("Deducer") 
library(Deducer)
tabla = contingency.tables(row.vars=d(LLENGUA),col.vars=d(EDAT),data=Llengua)
tabla = add.chi.squared(tabla)
print(tabla,prop.r=T,prop.c=T,prop.t=T,expected.n=T,residuals=T,std.residuals=T,adj.residuals=T)

# Grfico de barras apiladas al 100%
ggplot() + geom_bar(aes(y = ..count..,x = EDAT,fill = LLENGUA),data=Llengua,position = position_fill()) +
           scale_y_continuous(labels=scales::percent) + ylab ("%") 

# Para obtener la V de Cramer con el paquete "vcd" ejecutando "assocstats"
# install.packages("vcd") 
library(vcd)
assocstats(table(Llengua$LLENGUA, Llengua$EDAT))

# Paquete gmodels para obtener la tabla y la prueba de Chi-cuadrado
# install.packages("gmodels") 
library(gmodels)
CrossTable(Llengua$LLENGUA, Llengua$EDAT, prop.t=TRUE, prop.r=TRUE, prop.c=TRUE, chisq=TRUE, 
           resid=TRUE, sresid=TRUE, asresid=TRUE, format="SPSS")
