* Encoding: windows-1252.
* Anlisis de varianza. Datos de AQU.

MEANS TABLES=ICO BY Educapm
  /CELLS=MEAN COUNT STDDEV MIN MAX MEDIAN
  /STATISTICS ANOVA LINEARITY.

* Generador de grficos.
GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=Area COUNT()[name="COUNT"] MISSING=LISTWISE 
    REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: Area=col(source(s), name("Area"), unit.category())
  DATA: COUNT=col(source(s), name("COUNT"))
  GUIDE: axis(dim(1), label("Area de estudio"))
  GUIDE: axis(dim(2), label("Recuento"))
  SCALE: cat(dim(1), include("1", "2", "3", "4", "5", "6"))
  SCALE: linear(dim(2), include(0))
  ELEMENT: line(position(Area*COUNT), missing.wings())
END GPL.

* Generador de grficos.
GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=Area ICO MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: Area=col(source(s), name("Area"), unit.category())
  DATA: ICO=col(source(s), name("ICO"))
  DATA: id=col(source(s), name("$CASENUM"), unit.category())
  GUIDE: axis(dim(1), label("Area de estudio"))
  GUIDE: axis(dim(2), label("ndice de calidad ocupacional"))
  SCALE: cat(dim(1), include("1", "2", "3", "4", "5", "6"))
  SCALE: linear(dim(2), include(0))
  ELEMENT: schema(position(bin.quantile.letter(Area*ICO)), label(id))
END GPL.

ONEWAY ICO BY Educapm
  /STATISTICS DESCRIPTIVES HOMOGENEITY BROWNFORSYTHE WELCH 
  /PLOT MEANS
  /MISSING ANALYSIS
  /POSTHOC=T2 ALPHA(0.05).

UNIANOVA ICO BY Educapm
  /METHOD=SSTYPE(3)
  /INTERCEPT=INCLUDE
  /POSTHOC=Educapm(T2) 
  /PLOT=PROFILE(Educapm)
  /PRINT=ETASQ HOMOGENEITY DESCRIPTIVE
  /CRITERIA=ALPHA(.05)
  /DESIGN=Educapm.

GLM ICO BY Area
  /METHOD=SSTYPE(3)
  /INTERCEPT=INCLUDE
  /POSTHOC=Area(T2) 
  /PLOT=PROFILE(Area)
  /PRINT=ETASQ HOMOGENEITY DESCRIPTIVE
  /CRITERIA=ALPHA(.05)
  /DESIGN=Area.

UNIANOVA ICO BY Area Territorio
  /METHOD=SSTYPE(3)
  /INTERCEPT=INCLUDE
  /SAVE=PRED RESID ZRESID
  /POSTHOC=Area(SCHEFFE) 
  /PLOT=PROFILE(Area Territorio Area*Territorio Territorio*Area)
  /EMMEANS=TABLES(OVERALL) 
  /EMMEANS=TABLES(Area) COMPARE ADJ(BONFERRONI)
  /EMMEANS=TABLES(Territorio) COMPARE ADJ(BONFERRONI)
  /EMMEANS=TABLES(Area*Territorio) COMPARE (Territorio) ADJ (Bonferroni)
  /PRINT=ETASQ HOMOGENEITY DESCRIPTIVE PARAMETER
  /CRITERIA=ALPHA(.05)
  /DESIGN=Area Territorio Area*Territorio.

* Recodificacin de los ingresos individuales para codificarla con la marca de clase.
FREQUENCIES P46.
RECODE P46 (1=0)(2=150)(3=450)(4=750)(5=1050)(6=1500)(7=2100)(8=2700)(9=3750)(10=5250)(11=7500)(MISSING=9999)  INTO P46m.
VARIABLE LABELS  P46m 'Ingresos individuales (marca de clase)'.
VALUE LABELS P46m 9999 'NC'.
MISSING VALUES P46m(9999).
FORMATS  P46m (F2.0).
VARIABLE LEVEL  P46m (SCALE).
FREQUENCIES P46m /STATISTICS MEAN /HISTOGRAM.

UNIANOVA P46m BY Ocupacin P31 
  /METHOD=SSTYPE(3)
  /INTERCEPT=INCLUDE
  /SAVE=PRED RESID ZRESID
  /POSTHOC=Ocupacin(SCHEFFE) 
  /PLOT=PROFILE(Ocupacin P31 Ocupacin*P31 P31*Ocupacin)
  /EMMEANS=TABLES(OVERALL) 
  /EMMEANS=TABLES(Ocupacin) COMPARE ADJ(BONFERRONI)
  /EMMEANS=TABLES(P31) COMPARE ADJ(BONFERRONI)
  /EMMEANS=TABLES(Ocupacin*P31) COMPARE (P31) ADJ (Bonferroni)
  /PRINT=ETASQ HOMOGENEITY DESCRIPTIVE PARAMETER
  /CRITERIA=ALPHA(.05)
  /DESIGN=Ocupacin P31 Ocupacin*P31.
