* Comparacin de medias y ANOVA con CIS3041+.sav.

* Recodificacin de los ingresos individuales.
FREQUENCIES P46.
RECODE P46 (1=0)(2=150)(3=450)(4=750)(5=1050)(6=1500)(7=2100)(8=2700)(9=3750)(10=5250)(11=7500)(MISSING=9999)  INTO P46m.
VARIABLE LABELS  P46m 'Ingresos individuales (marca de clase)'.
VALUE LABELS P46m 9999 'NC'.
MISSING VALUES P46m(9999).
FORMATS  P46m (F2.0).
VARIABLE LEVEL  P46m (SCALE).
FREQUENCIES P46m /STATISTICS MEAN.
FREQUENCIES VARIABLES=P46m
  /HISTOGRAM
  /ORDER=ANALYSIS.

* Tabla de medias y anova.
MEANS TABLES=P46m BY ESTUDIOS
  /CELLS=MEAN COUNT STDDEV
  /STATISTICS ANOVA.

* Grfico de medias.
GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=ESTUDIOS MEAN(P46m)[name="MEAN_P46m"] 
    MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: ESTUDIOS=col(source(s), name("ESTUDIOS"), unit.category())
  DATA: MEAN_P46m=col(source(s), name("MEAN_P46m"))
  GUIDE: axis(dim(1), label("Estudios de la persona entrevistada"))
  GUIDE: axis(dim(2), label("Media Ingresos individuales (marca de clase)"))
  SCALE: linear(dim(2), include(0))
  ELEMENT: line(position(ESTUDIOS*MEAN_P46m), missing.wings())
END GPL.

* Anlisis exploratorio: descriptivos y diagrama de caja.
EXAMINE VARIABLES=P46m BY ESTUDIOS
  /PLOT BOXPLOT
  /COMPARE GROUPS
  /STATISTICS DESCRIPTIVES
  /CINTERVAL 95
  /MISSING LISTWISE
  /NOTOTAL.

* Prueba de la t de comparacin de dos medias: ingresos y sexo.
T-TEST GROUPS=P31(1 2)
  /MISSING=ANALYSIS
  /VARIABLES=P46m
  /CRITERIA=CI(.95).

