# Anova unifactorial

# Libreras "lsr" ("Learning Statistics with R"), "effects", "car" (para el test de Levene) y Deducer
# install.packages("lsr")
# install.packages("effects")
# install.packages("Deducer")
library(lsr)
library(effects)
library(car)
library(Deducer)

# Matriz de datos Valora.rda
load(url("http://pagines.uab.cat/plopez/sites/pagines.uab.cat.plopez/files/Valora.rda"))

# Asignacin de nombres a las variables
Y=Valora$Valora
A=Valora$Clase

# Tabla de medias
summary(Y ~ A)
descriptive.table(vars = d(Y), strata = d(A),data= Valora, 
                  func.names =c("Mean","St. Deviation","Valid N"))
library(psych)
describe.by(Y, A)

# Grficos: de medias y diagramas de caja
ggplot() + geom_line(aes(x=A, y=Y, group=1), data=Valora, fun.data=mean_sdl,
                     fun.args=list(mult=1), stat='summary')
plot(Y ~ A)

# Anlisis de varianza unifactorial
AV=aov(Y ~ A)
summary(AV)

# Condicionbes de aplicacin
hist(AV$residuals) # Histograma de los residuos
plot(AV) # Grficos de ajuste del modelo
leveneTest(Y ~ A, center=mean) # Prueba de igualdad de varianzas: Levene Test

# Comparacin de medias: Tukey's Honest Significance Test
summary(effect(term="A",mod=AV))
plot(effect(term="A",mod=AV,default.levels=20),rescale.axis=FALSE)
TukeyHSD(AV)
plot(TukeyHSD(AV),las=3)

# Capacidad explicativa y coeficientes
etaSquared(AV)
summary.lm(AV)
