* Encoding: UTF-8.
*  A un grupo de personas que pertenecen a tres clases sociales (alta, media y baja) 
   se les ha preguntado sobre la actitud que tienen hacia un cierto producto anunciado en televisin
   La informacin se ha registrado a partir de una escala que comprende del 1 al 9, con los resultados siguientes:
   Clase baja      5 6 9 6 8 5 7 7 6 9 5 7 5 6 8 5 7 6
   Clase media   6 7 4 4 5 5 6 6 3 4 4 3 
   Clase alta       1 3 2 1 4 3
   Se trata de contrastar la hiptesis segn la cual la valoracin media del producto es mayor entre las categoras ms bajas,
   es decir, que hay diferencias significativas entre las clases sociales respecto de la valoracin del producto.

DATA LIST FREE /VAL CLA.
BEGIN DATA
5 1
6 1
9 1
6 1
8 1
5 1
7 1
7 1
6 1
9 1
5 1
7 1
5 1
6 1
8 1
5 1
7 1
6 1
6 2
7 2
4 2
4 2
5 2
5 2
6 2
6 2
3 2
4 2
4 2
3 2
1 3
3 3
2 3
1 3
4 3
3 3
END DATA.
VARIABLE LABELS  CLA 'Clase'
                                 VAL "Valoracin".
VALUE LABELS  CLA 1 'Baja' 2 'Media'  3 'Alta'.
VARIABLE LEVEL VAL (SCALE) CLA (ORDINAL).
FORMATS VAL CLA (F1.0).

MEANS TABLES=VAL  BY CLA
  /CELLS MEAN STDDEV VARIANCE COUNT SUM.

MEANS TABLES=VAL  BY CLA
  /CELLS MEAN STDDEV VARIANCE COUNT SUM
  /STATISTICS ANOVA LINEARITY.

EXAMINE  VARIABLES=VAL BY CLA
  /PLOT BOXPLOT STEMLEAF HISTOGRAM
  /COMPARE GROUP
  /PERCENTILES(5,10,25,50,75,90,95) HAVERAGE
  /STATISTICS DESCRIPTIVES EXTREME
  /CINTERVAL 95
  /MISSING LISTWISE
  /NOTOTAL.

GRAPH
  /HILO(SIMPLE)=MAX(VAL) MIN(VAL) MEAN(VAL) BY CLA
  /MISSING=LISTWISE .

OLAP CUBES
  VAL   BY CLA
  /CELLS=SUM COUNT MEAN STDDEV SPCT NPCT
  /TITLE='Cubos OLAP'.

T-TEST GROUPS=CLA(1,2) /VARIABLES=VAL.
T-TEST GROUPS=CLA(1,3) /VARIABLES=VAL.
T-TEST GROUPS=CLA(2,3) /VARIABLES=VAL.

ONEWAY
  VAL BY CLA
  /STATISTICS DESCRIPTIVES EFFECTS HOMOGENEITY BROWNFORSYTHE WELCH
  /PLOT MEANS
  /MISSING ANALYSIS
  /POSTHOC = SCHEFFE ALPHA(.05).

ANOVA VAL BY CLA(1,3)
 /STATISTICS=ALL.


