
# Introduccin de la tabla de contingencia como Data Frame.
A = c("Admitted","Admitted","Admitted","Admitted","Admitted","Admitted","Rejected","Rejected","Rejected","Rejected","Rejected","Rejected","Admitted","Admitted","Admitted","Admitted","Admitted","Admitted","Rejected","Rejected","Rejected","Rejected","Rejected","Rejected")
S = c("Women","Women","Women","Women","Women","Women","Women","Women","Women","Women","Women","Women","Men","Men","Men","Men","Men","Men","Men","Men","Men","Men","Men","Men")
D = c("A","B","C","D","E","F","A","B","C","D","E","F","A","B","C","D","E","F","A","B","C","D","E","F")
Fre = c(89,17,202,131,94,24,19,8,391,244,299,317,512,353,120,138,53,22,314,207,205,279,138,351)
matriz = data.frame(A,S,D,Fre)
matriz

# Funcin que convierte un "data frame" de frecuencias a un "data frame" de casos.
# 'countcol' es el nombre de la columna que tiene las frecuencias.
CountsToCases <- function(x, countcol = "Fre") {
  # Indice de fila de los datos del data frame x
  idx <- rep.int(seq_len(nrow(x)), x[[countcol]])
  # Extrae la columna de frecuencias
  x[[countcol]] <- NULL
  # Toma las filas del data frame x
  x[idx, ]
}

# Creacin de un archivo externo sin formato.
write.table(CountsToCases(matriz),file='D:/Datos/Berkeley.dat')
# Importacin a R.
Berkeley <- read.table("D:/Datos/Berkeley.dat",header=T,sep="",quote="\"")
# Se guarda en formato de R.
save(Berkeley,file='D:/Datos/Berkeley.rda')