# Introduccin de una tabla de contingencia como "table".
tabla=as.table(matrix(c(16,2,20,10),nrow=2,ncol=2))
dimnames(tabla)=list(c("S","No"),c("Alta","Baja"))
names(dimnames(tabla))=c("Coche","Clase")
tabla

# Introduccin de la tabla de contingencia como Data Frame.
Coche = c("S","No","S","No")
Clase = c("Alta","Alta","Baja","Baja")
Fre = c(16,2,20,10)
matriz = data.frame(Coche,Clase,Fre)
matriz
t=xtabs(Fre ~ Coche + Clase, data=matriz)
t
summary(t)

# Funcin que convierte un "data frame" de frecuencias a un "data frame" de casos.
# 'countcol' es el nombre de la columna que tiene las frecuencias.
CountsToCases <- function(x, countcol = "Fre") {
  # Indice de fila de los datos del data frame x
  idx <- rep.int(seq_len(nrow(x)), x[[countcol]])
  # Extrae la columna de frecuencias
  x[[countcol]] <- NULL
  # Toma las filas del data frame x
  x[idx, ]
}

CountsToCases(matriz)

# Introduccin de la tabla de contingencia como Data Frame.
Coche = c("S","No","S","No","S","No")
Clase = c("Alta","Alta","Media","Media","Baja","Baja")
Fre = c(650,64,1234,333,1430,1036)
matriz = data.frame(Coche,Clase,Fre)
matriz
# Creacin de un archivo externo sin formato.
write.table(CountsToCases(matriz),file='D:/Datos/Coche.dat')
# Importacin a R.
Coche <- read.table("D:/Datos/Coche.dat",header=T,sep="",quote="\"")
# Se guarda en formato de R.
save(Coche,file='D:/Datos/Coche.rda')