# Instrucciones de transformacin del captulo III.2 del manual:
# Lpez-Roldn, P.; Fachelli, S. (2015). Metodologa de la Investigacin Social Cuantitativa
# Bellaterra (Cerdanyola del Valls): Dipsit Digital de Documents, Universitat Autnoma de Barcelona
# 1 edicin. Edicin digital: http://ddd.uab.cat/record/129382.

# Las instrucciones se pueden ejecutar todas en conjunto o una por una para ver con detenimiento 
# los efectos y resultados.

# Establecemos como espacio de trabajo el directorio D:/Datos, pero es necesario cambiarlo en cada caso
setwd("D:/Datos/")
getwd()
# Abrimos la matriz de datos CIS3041.rda
load("CIS3041.rda")
# Vemos el nombre de objeto que le asigna R
ls()

# Tras pedir las frecuencias convertimos a NA el valor "Militar" de OCUMAR11 y OCUPAPAD y vemos como queda
frequencies(CIS3041[c("OCUMAR11","OCUPAPAD")])
levels(CIS3041$OCUMAR11)
levels(CIS3041$OCUMAR11)[which(levels(CIS3041$OCUMAR11)=="Militar")] = NA
levels(CIS3041$OCUPAPAD)
levels(CIS3041$OCUPAPAD)[which(levels(CIS3041$OCUPAPAD)=="Militar")] = NA
frequencies(CIS3041[c("OCUMAR11","OCUPAPAD")])

# Tabla de contingencia de efectivos absolutos cruzando OCUMAR11 y OCUPAPAD
tables<-contingency.tables(row.vars=d(OCUMAR11),col.vars=d(OCUPAPAD),data=CIS3041)
print(tables,prop.r=F,prop.c=F,prop.t=F)

# Creamos la nueva variable de movilidad y sacamos frecuencias
CIS3041$Movilidad=NA
CIS3041$Movilidad=ifelse(as.numeric(CIS3041$OCUPAPAD) < as.numeric(CIS3041$OCUMAR11),"Descendente",CIS3041$Movilidad)
CIS3041$Movilidad=ifelse(CIS3041$OCUPAPAD == CIS3041$OCUMAR11,"Inmovilidad",CIS3041$Movilidad)
CIS3041$Movilidad=ifelse(as.numeric(CIS3041$OCUPAPAD) > as.numeric(CIS3041$OCUMAR11),"Ascendente",CIS3041$Movilidad)
CIS3041$Movilidad=as.factor(CIS3041$Movilidad)
frequencies(CIS3041[c("Movilidad")])



