* Instrucciones de transformacin del captulo III.2 del manual:
Lpez-Roldn, P.; Fachelli, S. (2015). Metodologa de la Investigacin Social Cuantitativa
Bellaterra (Cerdanyola del Valls): Dipsit Digital de Documents, Universitat Autnoma de Barcelona
1 edicin. Edicin digital: http://ddd.uab.cat/record/129382.

* Las instrucciones se pueden ejecutar todas en conjunto o una por una para ver con detenimiento los efectos y resultados.

* Archivo de datos. Ojo: Asegurarse de la localizacin del archivo: ejecutar la instruccin: CD 'Directorio_de_trabajo' 
  En nuestro caso utilizamos el directorio D:\Datos, pero es necesario cambiarlo en cada caso.

CD 'D:\Datos'.  /* Directorio de trabajo por defecto. 
SHOW DIRECTORY. /* Muestra el directorio de trabajo por defecto.
* Abrimos la matriz de datos CIS3041.sav.
GET FILE='CIS3041.sav'.

* Ordenacin de variables.
SORT VARIABLES BY NAME (A).
GET FILE='CIS3041.sav'.   /* Volvemos a abrir la matriz con el orden inicial.

* Ordenacin de casos.
SORT CASES BY CCAA(A).
SORT CASES BY CCAA(A) PROV(A) MUN(A).
SORT CASES BY CUES(A).  /* Vuelve a la ordenacin original segn n de cuestionario.

* Seleccin de las mujeres de la muestra (filtrando) mirando las frecuencias de P39.
FREQUENCIES P39.
USE ALL.
COMPUTE filter_$=(P31 = 2).
VARIABLE LABELS filter_$ 'P31 = 2 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
FREQUENCIES P39.
FILTER OFF.

* Seleccin de las mujeres de la muestra (elimando los varones) mirando las frecuencias de P39.
USE ALL.
SELECT IF (P31 = 2).
FREQUENCIES P39.
GET FILE='CIS3041.sav'.   /* Volvemos a abrir la matriz con todos los casos.

* Seleccin de una muestra aleatoria del 10% de los casos mirando las frecuencias de P39.
USE ALL.
SAMPLE  .10.
FREQUENCIES P39.
GET FILE='CIS3041.sav'.   /* Volvemos a abrir la matriz con todos los casos.

* Seleccin de los 100 primeros casos mirando las frecuencias de P39.
FILTER OFF.
USE 1 thru 100.
FREQUENCIES P39.
GET FILE='CIS3041.sav'.   /* Volvemos a abrir la matriz con todos los casos.

* Segmentacin del archivo por sexo y descriptivos de P901 a P902. Comparar los grupos.
SORT CASES  BY P31.
SPLIT FILE LAYERED BY P31.
DESCRIPTIVES  P901 TO P902.
SPLIT FILE OFF.

* Segmentacin del archivo por sexo y descriptivos de P901 a P907. Organizar los resultados por grupos.
SORT CASES  BY P31.
SPLIT FILE SEPARATE BY P31.
DESCRIPTIVES  P901 TO P907.
SPLIT FILE OFF.

* Ponderacin de casos ajustando los casos a una distribucn del 50% entre varones y mujeres.
* Varones: 1240/1211=1,024 Mujeres: 1240/1269=0,977.
FREQUENCIES P31.
IF P31=1 PESO=1.024.
IF P31=2 PESO=0.977.
WEIGHT BY PESO.
FREQUENCIES P31.
WEIGHT OFF.
DELETE VARIABLES PESO.

* Ponderacin para reproducir una tabla de frecuencias.
DATA LIST FREE /formacin (F1.0) frecuencia (F7.1).
BEGIN DATA.
1	727,2
2	2627,3
3	5812,7
4	10896,9
5	5083,5
6	2745,0
7 10630,8
END DATA.
VARIABLE LABELS formacin 'Formacin EPA 4T 2014'.
VALUE LABELS formacin 1 'Analfabetos'
2 'Estudios primarios incompletos'
3 'Educacin primaria'
4 'Primera etapa de educacin secundaria y similar'
5 'Segunda etapa de educacin secundaria, con orientacin general'
6 'Segunda etapa de educacin secundaria con orientacin profesional'
7 'Educacin superior'.
FREQUENCIES formacin /PIECHART.
WEIGHT BY frecuencia.
FREQUENCIES formacin  /PIECHART.
SAVE OUTFILE='Tabla EPA.sav'.

* Abrimos la matriz IDH2014.sav.
GET FILE='IDH2014.sav'.
* Ponderacin de los pases por poblacin para calcular la media del PIB per cpita.
DESCRIPTIVES VARIABLES=GDPpercapita
  /STATISTICS=MEAN.
WEIGHT BY Population.
DESCRIPTIVES VARIABLES=GDPpercapita
  /STATISTICS=MEAN.
WEIGHT OFF.

* Abrimos la matriz CIS3041.sav pra realizar la agregracin por CC.AA.
GET FILE='CIS3041.sav'.
DATASET DECLARE CCAA.
SORT CASES BY CCAA.
AGGREGATE
  /OUTFILE='CCAA'
  /PRESORTED
  /BREAK=CCAA
  /P901_mean=MEAN(P901) 
  /P902_mean=MEAN(P902) 
  /P903_mean=MEAN(P903) 
  /P904_mean=MEAN(P904) 
  /P905_mean=MEAN(P905) 
  /P906_mean=MEAN(P906) 
  /P907_mean=MEAN(P907) 
  /P30_mean=MEAN(P30) 
  /P32_mean=MEAN(P32)
  /N_BREAK=N.
DATASET CLOSE CCAA.

* Abrimos la matriz X.sav para transponerla.
GET FILE='X.sav'.
FLIP VARIABLES=ID Contrato Salario.

* Abrimos la matriz casestovars.sav para pasar casos a variables.
GET  FILE='casestovars.sav'.
SORT CASES BY ID .
CASESTOVARS
  /ID=ID
  /GROUPBY=INDEX
  /COUNT=Ncasos "".

* Abrimos la matriz varstocases.sav para pasar variables a casos.
GET FILE='varstocases.sav'.
VARSTOCASES
  /MAKE Contrato FROM Contrato1 Contrato2
  /MAKE Salario FROM Salario1 Salario2
  /INDEX=Momento(2)
  /KEEP=ID
  /NULL=KEEP.

* Abrimos la matriz casestovars.sav para dividir el archivo en dos.
GET FILE='casestovars.sav'.
SPSSINC SPLIT DATASET SPLITVAR=Momento
/OUTPUT DIRECTORY= "D:\Datos" DELETECONTENTS=NO 
/OPTIONS NAMES=LABELS.
DATASET CLOSE *.

* Abrimos la matriz YA.sav para fusionar las variables de YB.sav.
GET FILE='YA.sav'.
DATASET NAME YA.
GET  FILE='YB.sav'.
DATASET NAME YB.
MATCH FILES /FILE=YA
  /FILE='YB'
  /BY ID.
EXECUTE.
DATASET CLOSE ALL.

* Abrimos la matriz Y1-3.sav para fusionar los casos de Y4-6.sav.
GET FILE='Y1-3.sav'.
DATASET NAME Y13.
GET  FILE='Y4-6.sav'.
DATASET NAME Y46.
ADD FILES /FILE=*
  /FILE='Y46'.
EXECUTE.
DATASET CLOSE ALL.

* Abrimos la matriz CIS3041.sav pra realizar diversas transformaciones con variables.
GET FILE='CIS3041.sav'.

* Recodificacin de la ocupacin.
RECODE OCUMAR11 (MISSING=5) (10=5) (1 thru 2=1) (3 thru 4=2) (5 thru 7=3) (8 thru 9=4) INTO Ocupacin.
VARIABLE LABELS  Ocupacin 'Clase ocupacional'.
FREQUENCIES Ocupacin.
VALUE LABELS Ocupacin 1 'Clase alta' 2 'Clase media' 3 'Trababajadores cualificados' 4 'Trabajadores no cualificados' 5 'Perdidos:NS,NC,FFAA'.
MISSING VALUES Ocupacin (5).
VARIABLE LEVEL Ocupacin (ORDINAL).
FORMATS Ocupacin (F1.0).
FREQUENCIES Ocupacin.

* Recodificacin de la edad.
RECODE P32 (18 thru 24=1) (25 thru 34=2) (35 thru 44=3) (45 thru 54=4) (55 thru 64=5) (65 thru Highest=6) INTO Edad10.
VARIABLE LABELS  Edad10 'Edad de la persona entrevistada en grupos de 10'.
VALUE LABELS Edad10 1 '18-24' 2 '25-34' 3 '35-44' 4 '45-54' 5 '55-64' 6	'65 y ms'.
VARIABLE LEVEL Edad10 (ORDINAL).
FORMATS Edad10 (F1.0).
FREQUENCIES Edad10.

* Agrupacin visual.
RECODE  P32 (MISSING=COPY) (LO THRU 34=1) (LO THRU 46=2) (LO THRU 62=3) (LO THRU HI=4) 
    (ELSE=SYSMIS) INTO Edad4.
VARIABLE LABELS  Edad4 'Edad de la persona entrevistada en cuartiles'.
FORMATS  Edad4 (F5.0).
VALUE LABELS  Edad4 1 '<= 34' 2 '35 - 46' 3 '47 - 62' 4 '63+'.
VARIABLE LEVEL  Edad4 (ORDINAL).
FREQUENCIES Edad4.

* Recodificacin de los ingresos.
FREQUENCIES P45.
RECODE P45 (1=0)(2=150)(3=450)(4=750)(5=1050)(6=1500)(7=2100)(8=2700)(9=3750)(10=5250)(11=7500)(MISSING=9999)  INTO P45m.
VARIABLE LABELS  P45m 'Ingresos del hogar (marca de clase)'.
VALUE LABELS P45m 9999 'NC'.
MISSING VALUES P45m(9999).
FORMATS  P45m (F2.0).
VARIABLE LEVEL  P45m (SCALE).
FREQUENCIES P45m /STATISTICS MEAN.

* Autorecodificacin.
AUTORECODE VARIABLES=P23   /INTO P23bis   /PRINT.
FREQUENCIES P23 P23bis.

* Clculo del ndice de participacin sociopoltica.
FREQUENCIES P1401 TO P1404.
COMPUTE P14ndice=(3-P1401)+(3-P1402)+(3-P1403)+(3-P1404).
VARIABLE LABELS  P14ndice 'ndice de participacin sociopoltica'.
FORMATS  P14ndice (F1.0).
VARIABLE LEVEL  P14ndice (SCALE).
FREQUENCIES P14ndice /STATISTICS MEAN.

* Clculo de la tipificacin de la edad.
DESCRIPTIVES VARIABLES=P32   /STATISTICS=MEAN STDDEV.
COMPUTE Edadtip=(P32 - 48.32) / 17.489.
DESCRIPTIVES VARIABLES=Edadtip.
DESCRIPTIVES VARIABLES=P32  /SAVE.
DESCRIPTIVES VARIABLES=zP32.

* Clculo de los indicadores SPA, IEP y ICP.
FREQUENCIES P4 P6.
COMPUTE SPA=((100*0.1)+(75*2.0)+(50*14.9)+(25*32.0)+(0*51.0))/100.
COMPUTE IEP=((100*13.3)+(50*55.4)+(0*31.3))/100.
COMPUTE ICP=(SPA+IEP)/2.
FREQUENCIES SPA IEP ICP.

* Recuento de casos.
COUNT P13recuento=P1301 P1302 P1303 P1304 P1305 P1306 P1307 P1308 P1309(1 thru 2).
VARIABLE LABELS  P13recuento 'Nmero de asociaciones a las que pertenece'.
FORMATS  P13recuento (F1.0).
VARIABLE LEVEL  P13recuento (SCALE).
FREQUENCIES P13recuento.

* Creacin de la variable tipolgica de movilidad ocupacional intergeneracional: padres e hijoa/as.
FREQUENCIES OCUPAPAD OCUMAR11.
* Consideramos valores perdidos desde el 10 hasta el 99.
MISSING VALUES OCUPAPAD OCUMAR11 (10 THRU 99).
* Tabla de contingencia.
CROSSTABS  TABLES=OCUPAPAD BY OCUMAR11.
* Trasnformaciones condicionales.
IF  (OCUPAPAD < OCUMAR11) Movilidad=1.
IF  (OCUPAPAD = OCUMAR11) Movilidad=2.
IF  (OCUPAPAD > OCUMAR11) Movilidad=3.
VARIABLE LABELS  Movilidad 'Movilidad ocupacional intergeneracional'.
VALUE LABELS Movilidad 1 'Descendente' 2 'Inmovilidad' 3 'Ascendente'.
FORMATS  Movilidad (F1.0).
VARIABLE LEVEL  Movilidad (ORDINAL).
FREQUENCIES Movilidad.

* Creacin de la variable tipolgica de movilidad ocupacional intergeneracional: criterio de dominancia.
* Ocupacin dominante de padres y madres.
FREQUENCIES OCUPAPAD OCUPAMAD.
MISSING VALUES OCUPAPAD OCUPAMAD ().
CROSSTABS  TABLES=OCUPAPAD BY OCUPAMAD.
DO IF (OCUPAPAD <= 9 AND OCUPAMAD <= 9).
IF  (OCUPAPAD < OCUPAMAD) OCUPAFAM=OCUPAPAD.
IF  (OCUPAPAD = OCUPAMAD) OCUPAFAM=OCUPAPAD.
IF  (OCUPAPAD > OCUPAMAD) OCUPAFAM=OCUPAMAD.
ELSE IF (OCUPAPAD <= 9 AND OCUPAMAD >= 10).
COMPUTE OCUPAFAM=OCUPAPAD.
ELSE IF (OCUPAMAD <= 9 AND OCUPAPAD >= 10).
COMPUTE OCUPAFAM=OCUPAMAD.
ELSE.
COMPUTE OCUPAFAM=0.
END IF.
MISSING VALUES OCUPAFAM (0).
VARIABLE LABELS  OCUPAFAM 'Ocupacin dominante de los padres y las madres'.
VALUE LABELS OCUPAFAM 1 'Directores/as y gerentes' 2 'Tcnicos/as y profesionales cientficos/as e intelectuales'
3 'Tcnicos/as; profesionales de apoyo' 4 'Empleados/as contables, administrativos/as y otros empleados/as de oficina'
5 'Trabajadores/as de los servicios de restauracin, personales, proteccin y vendedores/as'
6 'Trabajadores/as cualificados/as en el sector agrcola, ganadero, forestal y pesquero' 
7 'Artesanos/as y trabajadores/as cualificados/as de las industrias manufactureras y la construccin, excepto operadores/as de instalaciones y maquinaria'
8 'Operadores/as de instalaciones y maquinaria, y montadores/as' 9 'Ocupaciones elementales'
0 'Sin datos'.
FORMATS  OCUPAFAM (F1.0).
VARIABLE LEVEL  OCUPAFAM (ORDINAL).
FREQUENCIES OCUPAFAM.
MISSING VALUES OCUPAPAD OCUPAMAD (10 THRU 99).
* Variable tipolgica de movilidad.
CROSSTABS  TABLES=OCUPAFAM BY OCUMAR11.
IF  (OCUPAFAM < OCUMAR11) Movilidad2=1.
IF  (OCUPAFAM = OCUMAR11) Movilidad2=2.
IF  (OCUPAFAM > OCUMAR11) Movilidad2=3.
VARIABLE LABELS  Movilidad2 'Movilidad ocupacional intergeneracional'.
VALUE LABELS Movilidad2 1 'Descendente' 2 'Inmovilidad' 3 'Ascendente'.
FORMATS  Movilidad2 (F1.0).
VARIABLE LEVEL  Movilidad2 (ORDINAL).
FREQUENCIES Movilidad2.

* Guardamos el archivo con todas las variables creadas.
SAVE OUTFILE='CIS3041+.sav'.

