####ANALYSIS OF COVARIANCE

#Reading and writting the data
TRIGCHANGE.TAB<-read.csv2("trigchange.csv", header=T)
attach(TRIGCHANGE.TAB)
write.table(TRIGCHANGE.TAB, quote=F)
summary(TRIGCHANGE.TAB)

#Represent data
stripchart(TRIGCHANGE~TRT, method="jitter", jitter=0.05, pch=16, vert=T); dev.new()

#Boxplot by groups
boxplot(TRIGCHANGE~TRT, TRIGCHANGE.TAB); dev.new()

#Splitting observations according to treatment
TRIG.FIB <- TRIGCHANGE.TAB[TRT=="fibralo",]
TRIG.GEM <- TRIGCHANGE.TAB[TRT=="gemfibro",]

#Plot of triglyceride change against HbA1c
plot(HBA1C, TRIGCHANGE, pch=as.numeric(TRT))

#Fit a regression line for each treatment
LM.FIB <- lm(TRIGCHANGE~HBA1C, data=TRIG.FIB)
LM.GEM <- lm(TRIGCHANGE~HBA1C, data=TRIG.GEM)

#Add the regression lines (abline) to the graphic
abline(LM.FIB)
abline(LM.GEM)

#One way anova
anova(aov(TRIGCHANGE~TRT))

#Table of descriptive statistics
m<-tapply(TRIGCHANGE, TRT, length)
p<-tapply(TRIGCHANGE, TRT, mean)
r<-tapply(TRIGCHANGE, TRT, sd)
cbind(N=m, Mean=p, Std.dev=r)


#Analysis of covariance
anova(lm(TRIGCHANGE~HBA1C*TRT))
summary(lm(TRIGCHANGE~HBA1C*TRT))
anova(lm(TRIGCHANGE~HBA1C+TRT))
summary(lm(TRIGCHANGE~HBA1C+TRT))


#ANOVA diagnostics with 4 graphs/page
layout(matrix(c(1,2,3,4),2,2))  
plot(lm(TRIGCHANGE~HBA1C*TRT))

#ANOVA diagnostics with 4 graphs/page
layout(matrix(c(1,2,3,4),2,2))  
plot(lm(TRIGCHANGE~HBA1C+TRT))

q()
