####COMPLETELY RANDOM DESIGN - ONE WAY ANOVA

#Reading and writting the data
CONFBEEF<-read.csv2("confbeef.csv", header=T)
attach(CONFBEEF) # attach puts the data frame in the search path 
write.table(CONFBEEF, quote=F)

#Represent data
stripchart(CONF~TRT, method="jitter", jitter=0.05, pch=16, vert=T)
#Boxplot by groups
boxplot(CONF~TRT, CONFBEEF)

#Assessing homogeneity of variance assumption:
#Bartlett test
bartlett.test(CONF~TRT, CONFBEEF)
#Levene test (an alternative to Bartlett test, less sensitive to non-normality)
library(car)
leveneTest(y = CONF, group = TRT) 

#Plot of mean vs variance
plot(tapply(CONF, TRT, mean), tapply(CONF, TRT, var))

#Testing H0, i.e., population means are equal
CONFBEEF.AOV<-aov(CONF~TRT, CONFBEEF)
#Examine the ANOVA table
anova(CONFBEEF.AOV)
summary.lm(aov(CONF~TRT))

#An alternative to the aov command is lm (linear model)
CONFBEEF.LM<-lm(CONF~TRT, CONFBEEF)
anova(CONFBEEF.LM)
summary(CONFBEEF.LM)

#ANOVA diagnostics with 4 graphs/page
layout(matrix(c(1,2,3,4),2,2))  
plot(CONFBEEF.AOV)

#Table of descriptive statistics
print(model.tables(CONFBEEF.AOV,"means"))   
M<-tapply(CONF, TRT, length)
P<-tapply(CONF, TRT, mean)
R<-tapply(CONF, TRT, sd)
cbind(N=M, Mean=P, Std.dev=R)

#Graphical representation
barplot(P, xlab="Treatment", ylab="SEUROP conformation", col="blue")

#Standard errors in a graphic (seBars function) from R-book p 216
#To get the 95% confidence intervals in the error bars write in this case  sem*qt(.975,10)instead of sem
seBars<-function(x,y){
	model<-lm(y~factor(x))
	reps<-length(y)/length(levels(x))
	sem<-summary(model)$sigma/sqrt(reps)
	m<-as.vector(tapply(y,x,mean))
	upper<-max(m)+sem
	nn<-as.character(levels(x))
	xs<-barplot(m,ylim=c(0,upper),names=nn,col="green",
	ylab=deparse(substitute(y)),xlab=deparse(substitute(x)))
	for (i in 1:length(xs)){
		arrows(xs[i],m[i]+sem,xs[i],m[i]-sem, angle=90,code=3,length=0.1)}
}

seBars(TRT, CONF)

#Post-hoc Tukey's test to investigate pairwise mean
#differences between groups (treatments)
CONFBEEF.TUKEY<-TukeyHSD(CONFBEEF.AOV,"TRT")
CONFBEEF.TUKEY
plot(CONFBEEF.TUKEY)

#To detect groups that did/did not differ in the Tukey test
library(agricolae)
HSD.test(CONFBEEF.AOV, "TRT")

#Contrasts
contrasts(TRT)<-cbind(c(-0.5, 1, -0.5), c(1, 0, -1)) #be careful
#depending on the order of the contrasts it is possible to find nonsense results
round(crossprod(contrasts(TRT)), 2) #this checks for orthogonal (independent) contrasts
summary(CONFBEEF.AOV, split=list(TRT=list("T2 vs (T1+T3)/2"=1, "T1 vs T3"=2)))

#Power in a CRD-one way ANOVA
ACONFBEEF<-anova(lm(CONF~TRT, CONFBEEF))
DFB<-ACONFBEEF[["Df"]][1]
DFW<-ACONFBEEF[["Df"]][2]
SSB<-ACONFBEEF[["Sum Sq"]][1]
MSW<-ACONFBEEF[["Mean Sq"]][2]
LAMBDA=SSB/MSW; ALPHA=0.05
FCRIT<-qf(1-ALPHA,DFB,DFW)
POWER<-1-pf(FCRIT,DFB,DFW,LAMBDA)
cbind(Sig.level=ALPHA, DF.between=DFB, DF.within=DFW, POWER=POWER)

#Determining sample size for the analyzed design (for a balanced design)
for (n in 2:20) {
DFW[n] <- (DFB+1)*(n-1) 
FCRIT[n]<-qf(1-ALPHA,DFB,DFW[n])
POWER[n]<-1-pf(FCRIT[n],DFB,DFW[n],LAMBDA)
    if(POWER[n]>=.80 && n<10){
    print(paste("n =", as.numeric(n),"  ", "Power =", round(POWER[n], digits=7)), quote=FALSE)
    }
    else if(POWER[n]>=.80 && n>=10){
    print(paste("n =", as.numeric(n)," ", "Power =", round(POWER[n], digits=7)), quote=FALSE)
    }
}

detach(CONFBEEF)

q()
