#### FISH GROWTH

FISHG<-read.csv2("fishgrowth.csv", header=T)
attach(FISHG)
str(FISHG)
summary(FISHG)

plot(AGE, LENGTH, pch=19, col="orange")

##Polynomial fit

AGE2=AGE^2; AGE3=AGE^3; AGE4=AGE^4

L.POL1<-lm(LENGTH ~ AGE)
summary(L.POL1)
anova(L.POL1)

L.POL2<-lm(LENGTH ~ AGE + AGE2)
summary(L.POL2)
anova(L.POL2)

L.POL3<-lm(LENGTH ~ AGE + AGE2 + AGE3)
summary(L.POL3)
anova(L.POL3)

L.POL4<-lm(LENGTH ~ AGE + AGE2 + AGE3 + AGE4)
summary(L.POL4)
anova(L.POL4)

plot(AGE, LENGTH, pch=19, col="orange")
lines(AGE, predict(L.POL1), type="l", col="maroon")
lines(AGE, predict(L.POL2), type="l", col="red")
lines(AGE, predict(L.POL3), type="l", col="darkblue")
lines(AGE, predict(L.POL4), type="l", col="darkgreen")
legend(100, 30, c("Linear", "Quadratic", "Cubic", "Quartic"), pch=151, col=c("maroon", "red", "darkblue", "darkgreen"))


#Splines

library(segmented)
L.SEG<- segmented(lm(LENGTH~AGE), seg.Z=~AGE, psi=c(80)) #for more than one knot psi=c(..., ..., ...)
summary(L.SEG)
anova(L.SEG)
vcov(L.SEG)
intercept(L.SEG)
slope(L.SEG)
confint(L.SEG) # estimate and CI of the knot

plot(AGE, LENGTH, pch=19, col="orange")
lines(AGE, predict(L.SEG), type="l", col="darkblue")


#Logistic curve

L.LOG<-nls(LENGTH ~ k/(1+((k-y0)/y0)*exp(-r*AGE)),
           start=list(k = 40, y0 = 1, r = .05),
           algorithm = "port", 
           model=T)
summary(L.LOG)
confint(L.LOG)

plot(AGE, LENGTH, pch=19, col="orange")
lines(AGE, predict(L.LOG), type="l", col="darkgreen")

q()