####FACTORIAL DESIGN - TWO WAY ANOVA

#Reading and writting the data
SOLUB.CAP<-read.csv2("solub.csv", header=T)
attach(SOLUB.CAP)
dim(SOLUB.CAP)
summary(SOLUB.CAP)
write.table(SOLUB.CAP, quote=F)

#Boxplot by groups
boxplot(SOLUB~JUICE); dev.new()
boxplot(SOLUB~CAPSULE); dev.new()
boxplot(SOLUB~JUICE*CAPSULE)

#Testing H0, i.e., population means are equal
SOLUB.AOV<-aov(SOLUB ~ CAPSULE*JUICE)
anova(SOLUB.AOV)
summary.lm(SOLUB.AOV)

#ANOVA diagnostics for interaction effects 
layout(matrix(c(1,2),1,2)) 
plot(SOLUB.AOV, which=c(1,2))

#Table of descriptive statistics
tapply(SOLUB,list(CAPSULE, JUICE),mean)
interaction.plot(CAPSULE, JUICE, SOLUB)  

q()

