####KRUSKAL-WALLIS TEST
##Non parametric test corresponding to ANOVA for
##normal distributions

#Reading data
KW<-read.csv2("kw.csv", header=T) 
attach(KW) 
summary(KW)

boxplot(SCORE~DOSE)

#Contrasting normality within each treatment
KW.PBO <- KW[DOSE=="PBO",]; shapiro.test(KW.PBO$SCORE) 
KW.D01 <- KW[DOSE=="D01",]; shapiro.test(KW.D01$SCORE)
KW.D02 <- KW[DOSE=="D02",]; shapiro.test(KW.D02$SCORE)

#Comparing the means 
kruskal.test(SCORE~DOSE)

#Anova to compare with KW test
PSOR.AOV <- aov(SCORE~DOSE, KW)
anova(PSOR.AOV)

q()