####LATIN SQUARES

#Reading data from an external file
LATINSQ<- read.csv2("ls.csv", header=T) 
attach(LATINSQ)
dim(LATINSQ)
summary(LATINSQ)

#Boxplots for each factor
plot(YIELD ~ DAY, LATINSQ); dev.new()
plot(YIELD ~ OPERATOR, LATINSQ); dev.new()
plot(YIELD ~ TRT, LATINSQ)

#Analysis of variance
LATINSQ.AOV <- lm(YIELD ~ DAY + OPERATOR + TRT, LATINSQ)
anova(LATINSQ.AOV)
summary(LATINSQ.AOV)

#Anova diagnostics
plot(LATINSQ.AOV$fit,LATINSQ.AOV$res,xlab="Fitted",ylab="Residuals"); dev.new()
qqnorm(LATINSQ.AOV$res,ylab="Residuals")

#Table of descriptive statistics
tapply(YIELD,list(TRT),mean)

#Post-hoc Tukeys test to investigate pairwise mean
#differences between groups (treatments)
library(multcomp)
summary(glht(LATINSQ.AOV, linfct=mcp (TRT="Tukey")))

library(agricolae)
HSD.test(LATINSQ.AOV, "TRT")

#Relative efficiency
LATINSQ.CRD <- lm(YIELD ~ TRT, LATINSQ)
anova(LATINSQ.CRD)
LATINSQ.RCBDr <- lm(YIELD ~ DAY + TRT, LATINSQ)
anova(LATINSQ.RCBDr)
LATINSQ.RCBDc <- lm(YIELD ~ OPERATOR + TRT, LATINSQ)
anova(LATINSQ.RCBDc)
#the relative efficiency (quotient between Residuals MS)
#must be calculated by hand, with the aid for example of R.

q()
