####MULTIPLE CORRELATION AND REGRESSION

##Importing data
TEND.AM<-read.csv2("tendAM.csv", header=T) 
attach(TEND.AM); options(na.action=na.exclude)
dim(TEND.AM)
summary(TEND.AM)

##Scatterplot
library(car)
scatterplotMatrix(~ADG+LMAREA+CONF+FAT+INTRAMFAT+WHC+DRYMAT+COOKLOSS+
+TEXTWB+TENDERNESS, diag="boxplot"); dev.new()

##Linear model
TEND.LM<-lm(TENDERNESS~ADG+LMAREA+CONF+FAT+INTRAMFAT+WHC+DRYMAT+COOKLOSS+TEXTWB)
#note that all of the regressors in the dataframe can be substituted by a . in the model
summary(TEND.LM)
anova(TEND.LM)

#Multicollinearity diagnostics
cor(TEND.AM[,1:10])
VIF<-vif(TEND.LM)
TOL<-1/vif(TEND.LM)
cbind(VIF=VIF, Tol=TOL)

#Diagnostics of residuals and influence
layout(matrix(c(1,2,3,4),2,2)) 
plot(TEND.LM)
plot(fitted(TEND.LM), rstandard(TEND.LM)); dev.new()

data.frame(Tender.=TENDERNESS, Predicted=fitted(TEND.LM), Residuals=resid(TEND.LM), RIstudent=rstandard(TEND.LM), REstudent=rstudent(TEND.LM))

influence.measures(TEND.LM)

##Model selection
# Stepwise Regression
step(TEND.LM)
summary(step(TEND.LM))


#More in model selection
library(leaps)
TEND.LEAPS<-regsubsets(TENDERNESS~., data=TEND.AM, nbest=2)
# view results 
RS<-summary(TEND.LEAPS)
# plot a table of models showing variables in each model.
# models are ordered by the selection statistic.
plot(TEND.LEAPS, scale="r2") #if no scale option is specified, the default is AIC

#Plotting Cp Mallows
x <- model.matrix(TEND.LM)[,-1]
y <- TEND.AM$TENDERNESS
g <- leaps(x,y) #needs library leaps activated
library(faraway)
Cpplot(g)
adjr <- leaps(x,y,method="adjr2")
maxadjr(adjr,4)  

#plot statistic by subset size 
library(car)
subsets(TEND.LEAPS, statistic="rsq") 

q()

