#### CORRELATION AND REGRESSION ANALYSIS

## Importing data
BLOODP<-read.csv2("bloodpress.csv", header=T) 
attach(BLOODP); options(na.action=na.exclude)
summary(BLOODP)

## Plotting the data
plot(BLPRESS~AGE); dev.new()
library(car); scatterplot(BLPRESS~AGE)

## Correlation
cor(BLPRESS, AGE)
cor.test(BLPRESS, AGE)

## Single Linear Regression  
BLOODP.REG <- lm(BLPRESS~AGE)
summary(BLOODP.REG)
anova(BLOODP.REG)
confint(BLOODP.REG,level=0.95)

## Regression diagnostics
data.frame(BLOODP, Predicted=fitted(BLOODP.REG), Residuals=resid(BLOODP.REG), 
RIstudent=rstandard(BLOODP.REG), Restudent=rstudent(BLOODP.REG))

influence.measures(BLOODP.REG)
summary(influence.measures(BLOODP.REG))

layout(matrix(c(1,2,3,4),2,2)) # optional 4 graphs/page 
plot(BLOODP.REG)


## Summary scatterplot
#cretate a plot with solid dots (pch=16) and no axis or labels
plot(BLPRESS~AGE, pch=16, axes=F, xlab="", ylab="")
#put the x-axis (axis1) with smaller label font size
axis(1, cex.axis=.8)
#put the x-axis label 3 lines down from the axis
mtext(text="Age (years)", side=1, line=3)
#put the y-axis (axis 2) with horizontal tick labels
axis(2, las=1)
#put the y-aix label 3 lines to the left of the axis
mtext(text= "Blood pressure (mm Hg)", side=2, line=3)
#add the regression line from the fitted model
abline(BLOODP.REG)
#add the regression formula
text(50,145,"Blood presure = 0.441*Age+112.32", pos=2)
#add the r squared value
text(50,143,expression(paste(R^2==0.935)), pos=2)
#create a sequence of 100 numbers spanning the range of ages
x<-seq(min(AGE), max(AGE), l=1000)
#for each value of x, calculate the upper and lower 95% confidence
y<-predict(BLOODP.REG, data.frame(AGE=x), interval="c")
#plot the upper and lower 95% confidence limits
matlines(x,y, lty=1, col=1)
#put an L-shaped box to complete the axis
box(bty="l")

q()




