####COMPARISON OF TWO MEANS OF INDEPENDENT SAMPLES

LMAREA.TABLE<-read.csv2("lmareaAMBP.csv", header=T) 
attach(LMAREA.TABLE) # attach puts the data frame in the search path 
summary(LMAREA.TABLE) 

#Are the variances equal?
ttestv<-var.test(LMAREA~BREED)
ttestv

if (ttestv$p.value>0.05) {
	print("Variances are equal", quote=F)
	tteste<-t.test(LMAREA~BREED, var.equal=T)
	tteste
} else {
	print("Variances are unequal", quote=F)
	ttestu<-t.test(LMAREA~BREED)
	ttestu
}

#Graphical representation of the two means
means<-tapply(LMAREA, BREED, mean)
barplot(means, xlab="Breed", ylab="loin muscle area, cm", col="yellow")


###Power of a two sample comparison of means, two sided test
#qt(p,df): quantile at the critical point p of a t distribution,
#with df degrees of freedom
#pt(qt(p,df),df,ncp): cumulated probability until the quantile in a 
#noncentral t distribution with df degrees of freedom and noncentrality 
#parameter ncp 
 
#str of ttestv, tteste, ttestu indicates that parameters stands for df
#and statistics is the t-value

if(ttestv$p.value >= 0.05){
	print("Power for equal variances", quote=F)
	POWERL <- pt(qt(0.025,tteste$parameter),tteste$parameter,tteste$statistic); POWERL
	POWERR <- 1-pt(qt(0.975,tteste$parameter),tteste$parameter,tteste$statistic); POWERR
	POWER2t <- POWERL + POWERR; POWER2t
} else {
	print("Power for unequal variances", quote=F)
	POWERL <- pt(qt(0.025,ttestu$parameter),ttestu$parameter,ttestu$statistic); POWERL
	POWERR <- 1-pt(qt(0.975,ttestu$parameter),ttestu$parameter,ttestu$statistic); POWERR
	POWER2t <- POWERL + POWERR; POWER2t
}

q()
