####TABLE OF DESCRIPTIVE STATISTICS 
####of a continuous variable (ADG) according to several 
####levels of a clasificatory variable (BREED)

ADG.TABLE<-read.csv2("adg6.csv", header=T) 
attach(ADG.TABLE)

#Calculating the elements of a summary table
M<-tapply(ADG, BREED, length)
N<-tapply(ADG, BREED, min)
O<-tapply(ADG, BREED, max)
P<-tapply(ADG, BREED, mean)
Q<-tapply(ADG, BREED, median)
R<-tapply(ADG, BREED, sd)
S<-tapply(ADG, BREED, shapiro.test) 
SS<-array(0,dim=c(length(levels(BREED)))) #Creates a vector of 6 zeroes
for(i in 1:length(levels(BREED))) {SS[i] <- S[[i]]$p.value}

#Combining the results into a table
cbind(n=M, min=N, max=O, mean=P, median=Q, std.dev=R, p.shapiro=SS)

#Boxplots per groups
boxplot(ADG~BREED)

q()
