####DESCRIPTIVE ANALYSIS OF A SINGLE DATASET

#Data
ADG <- c(1.99, 1.72, 1.95, 1.67, 1.51, 1.32, 1.39, 1.64, 1.78, 1.50, 1.43,
1.37, 1.60, 1.58, 1.76, 1.57, 1.81, 1.21, 1.45, 1.58, 1.58, 1.68, 1.61, 
1.61, 1.78, 1.95, 1.63, 1.68, 1.71, 1.74, 1.69, 1.68, 1.36, 1.30, 1.35,
1.24, 1.38, 1.32)

#Descriptive statistics
length(ADG)
min(ADG); max(ADG);
mean(ADG); median(ADG) 
var(ADG); sd(ADG); CV<-sd(ADG)/mean(ADG)*100; CV
quantile(ADG); IQR(ADG) 

#Inference about the mean
SEM<-sd(ADG)/sqrt(length(ADG)); SEM
YBAR<-mean(ADG);
LCL<-YBAR-SEM*qt(0.975,length(ADG)-1); LCL
UCL<-YBAR+SEM*qt(0.975,length(ADG)-1); UCL

#Numerical tests for normality
library(moments); skewness(ADG); kurtosis(ADG)-3
shapiro.test(ADG)     
ks.test(ADG, "pnorm", mean = mean(ADG), sd = sqrt(var(ADG)))

#Graphic tests for normality
hist(ADG); dev.new() 
stem(ADG)
boxplot(ADG); dev.new() 
qqnorm(ADG); qqline(ADG)

q()
